% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.redundant.names.R
\name{node.redundant.names}
\alias{node.redundant.names}
\title{Changes Variable Names to Descriptions for \code{\link[EGAnet]{node.redundant}} Objects}
\usage{
node.redundant.names(node.redundant.obj, key)
}
\arguments{
\item{node.redundant.obj}{A \code{\link[EGAnet]{node.redundant}} object}

\item{key}{Character vector.
A vector with variable descriptions that correspond
to the order of variables from the data used as input into the
\code{\link[EGAnet]{node.redundant}} function}
}
\value{
Returns a list:

\item{redundant}{Vectors nested within the list corresponding
to redundant nodes with the name of object in the list}

\item{data}{Returns original data}

\item{weights}{Returns weights determine by weighted topological overlap
or partial correlations}

\item{key}{Returns original key}
}
\description{
Using a key, this function changes the variable names in
the \code{\link[EGAnet]{node.redundant}} output to descriptions
}
\examples{
# obtain SAPA items
items <- psychTools::spi[,-c(1:10)]

\donttest{
# weighted topological overlap
redund <- node.redundant(items, type = "wTO", method = "adapt")

# partial correlation
redund <- node.redundant(items, type = "pcor", method = "adapt")

# check redundancies
key.ind <- match(colnames(items), as.character(psychTools::spi.dictionary$item_id))
key <- as.character(psychTools::spi.dictionary$item[key.ind])

# change names in redundancy output to questionnaire item description
named.nr <- node.redundant.names(redund, key)
}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
