% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.paf_iter}
\alias{.paf_iter}
\title{Perform the iterative PAF procedure}
\usage{
.paf_iter(h2, criterion, R, n_fac, abs_eig, crit_type, max_iter)
}
\arguments{
\item{h2}{numeric. The initial communality estimates.}

\item{criterion}{double. The convergence criterion to use.}

\item{R}{matrix. The correlation matrix with the initial communality estimates in the diagonal.}

\item{n_fac}{numeric. The number of factors to extract.}

\item{abs_eig}{logical. Whether absolute eigenvalues should be used to compute the loadings.}

\item{crit_type}{numeric. Whether maximum absolute differences (crit_type = 1), or sum of differences (crit_type = 2) should be used}

\item{max_iter}{numeric. The number of iterations after which to end the procedure if no convergence has been reached by then.}
}
\description{
Function called from within PAF so usually no call to this is needed by the user.
Provides a C++ implementation of the PAF procedure
}
