% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_authorized.R
\name{is_authorized}
\alias{is_authorized}
\title{Is authorized to read}
\usage{
is_authorized(resourceId, env = "production")
}
\arguments{
\item{resourceId}{(character) Resource identifier}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(logical) TRUE if the authenticated user has permission to read the
specified resource
}
\description{
Is authorized to read
}
\note{
User authentication is required (see \code{login()})
}
\examples{
\dontrun{

login()

# Get the most recently created data package
auditReport <- get_recent_uploads(
  query = "serviceMethod=createDataPackage&limit=1"
)

# Get the resourceId
resourceId <- xml2::xml_text(
  xml2::xml_find_all(auditReport, ".//resourceId")
)
resourceId
#> [1] "https://pasta.lternet.edu/package/eml/knb-lter-hbr/345/1"

# Check read authorization
is_authorized(resourceId)
#> [1] TRUE

logout()
}

}
\seealso{
Other Miscellaneous: 
\code{\link{create_data_package_archive}()},
\code{\link{create_dn}()}
}
\concept{Miscellaneous}
