% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexity.R
\name{complexity}
\alias{complexity}
\alias{complexity.default}
\alias{complexity.formula}
\title{Extract the complexity measures from datasets}
\usage{
complexity(...)

\method{complexity}{default}(x, y, groups = "all", ...)

\method{complexity}{formula}(formula, data, groups = "all", ...)
}
\arguments{
\item{...}{Not used.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{groups}{A list of complexity measures groups or \code{"all"} to include
all of them.}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class.}
}
\value{
A numeric vector named by the requested complexity measures.
}
\description{
This function is responsable to extract the complexity measures from the 
datasets. For such, they take into account the overlap between classes 
imposed by feature values, the separability and distribution of the data 
points and the value of structural measures based on the representation of 
the dataset as a graph structure. To set specific parameters for each group, 
use the characterization function.
}
\details{
The following groups are allowed for this method:
 \describe{
   \item{"overlapping"}{The feature overlapping measures characterize how 
     informative the available features are to separate the classes See 
     \link{overlapping} for more details.}
   \item{"neighborhood"}{Neighborhood measures characterize the presence and 
     density of same or different classes in local neighborhoods. See 
     \link{neighborhood} for more details.}
   \item{"linearity"}{Linearity measures try to quantify whether the classes 
     can be linearly separated. See \link{linearity} for more details.}
   \item{"dimensionality"}{The dimensionality measures compute information on
     how smoothly the examples are distributed within the classes. See 
     \link{dimensionality} for more details.}
   \item{"balance"}{Class balance measures take into account the numbers of 
     examples per class in the dataset. See \link{balance} for more details.}
   \item{"network"}{Network measures represent the dataset as a graph and 
     extract structural information from it. See \link{network} for more 
     details.}
 }
}
\examples{
## Extract all complexity measures
complexity(Species ~ ., iris)

## Extract the linearity measures
complexity(Species ~ ., iris, groups="linearity")
}
\references{
Tin K Ho and Mitra Basu. (2002). Complexity measures of supervised 
   classification problems. IEEE Transactions on Pattern Analysis and Machine
   Intelligence, 24, 3, 289--300.

 Albert Orriols-Puig, Nuria Macia and Tin K Ho. (2010). Documentation for 
   the data complexity library in C++. Technical Report. La Salle - 
   Universitat Ramon Llull.
}
