% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis.R
\name{evaluate_model_dia}
\alias{evaluate_model_dia}
\title{Evaluate Diagnostic Model Performance}
\usage{
evaluate_model_dia(
  model_obj = NULL,
  X_data = NULL,
  y_data,
  sample_ids,
  threshold_strategy = c("default", "f1", "youden", "numeric"),
  specific_threshold_value = 0.5,
  pos_class,
  neg_class,
  precomputed_prob = NULL,
  y_original_numeric = NULL
)
}
\arguments{
\item{model_obj}{A trained model object (typically a \code{caret::train} object
or a list from an ensemble like Bagging). Can be \code{NULL} if \code{precomputed_prob} is provided.}

\item{X_data}{A data frame of features corresponding to the data used for evaluation.
Required if \code{model_obj} is provided and \code{precomputed_prob} is \code{NULL}.}

\item{y_data}{A factor vector of true class labels for the evaluation data.}

\item{sample_ids}{A vector of sample IDs for the evaluation data.}

\item{threshold_strategy}{A character string, defining how to determine the
threshold for class-specific metrics: "default" (0.5), "f1" (maximizes F1-score),
"youden" (maximizes Youden's J statistic), or "numeric" (uses \code{specific_threshold_value}).}

\item{specific_threshold_value}{A numeric value between 0 and 1. Only used
if \code{threshold_strategy} is "numeric".}

\item{pos_class}{A character string, the label for the positive class.}

\item{neg_class}{A character string, the label for the negative class.}

\item{precomputed_prob}{Optional. A numeric vector of precomputed probabilities
for the positive class. If provided, \code{model_obj} and \code{X_data} are not used
for score derivation.}

\item{y_original_numeric}{Optional. The original numeric/character vector of labels.
If not provided, it's inferred from \code{y_data} using global \code{pos_label_value} and \code{neg_label_value}.}
}
\value{
A list containing:
\itemize{
\item \code{sample_score}: A data frame with \code{sample} (ID), \code{label} (original numeric),
and \code{score} (predicted probability for positive class).
\item \code{evaluation_metrics}: A list of performance metrics:
\itemize{
\item \code{Threshold_Strategy}: The strategy used for threshold selection.
\item \verb{_Threshold}: The chosen probability threshold.
\item \code{Accuracy}, \code{Precision}, \code{Recall}, \code{F1}, \code{Specificity}: Metrics
calculated at \verb{_Threshold}.
\item \code{AUROC}: Area Under the Receiver Operating Characteristic curve.
\item \code{AUROC_95CI_Lower}, \code{AUROC_95CI_Upper}: 95\% confidence interval for AUROC.
\item \code{AUPRC}: Area Under the Precision-Recall curve.
}
}
}
\description{
Evaluates the performance of a trained diagnostic model using
various metrics relevant to binary classification, including AUROC, AUPRC,
and metrics at an optimal or specified probability threshold.
}
\examples{
\donttest{
set.seed(42)
n_obs <- 50
X_toy <- data.frame(
  FeatureA = rnorm(n_obs),
  FeatureB = runif(n_obs, 0, 100)
)
y_toy <- factor(sample(c("Control", "Case"), n_obs, replace = TRUE),
                levels = c("Control", "Case"))
ids_toy <- paste0("Sample", 1:n_obs)

# 2. Train a model
rf_model <- rf_dia(X_toy, y_toy)

# 3. Evaluate the model using F1-score optimal threshold
eval_results <- evaluate_model_dia(
  model_obj = rf_model,
  X_data = X_toy,
  y_data = y_toy,
  sample_ids = ids_toy,
  threshold_strategy = "f1",
  pos_class = "Case",
  neg_class = "Control"
)
str(eval_results)
}
}
