% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eng_dynare.R
\name{eng_dynare}
\alias{eng_dynare}
\title{DynareR: A Seamless Integration of R and Dynare}
\usage{
eng_dynare(options)
}
\arguments{
\item{options}{Chunk options, as provided by \code{knitr} during chunk execution. Chunk option for this is \code{dynare}}
}
\value{
Set of \code{Dynare} (open-source software for DSGE modelling) codes
}
\description{
This package runs on top of knitr to facilitate communication with Dynare. Run Dynare scripts from R Markdown document.
}
\details{
The \code{dynare} engine can be activated via\preformatted{knitr::knit_engines$set(dynare = DynareR::eng_dynare)
}

This will be set within an R Markdown document's setup chunk.
}
\examples{
knitr::knit_engines$set(dynare = DynareR::eng_dynare)
library(DynareR)
}
\references{
Bob Rudis (2015).Running Go language chunks in R Markdown (Rmd) files. Available at:  https://gist.github.com/hrbrmstr/9accf90e63d852337cb7

Yihui Xie (2019). knitr: A General-Purpose Package for Dynamic Report Generation in R. R package version 1.24.

Yihui Xie (2015) Dynamic Documents with R and knitr. 2nd edition. Chapman and Hall/CRC. ISBN 978-1498716963

Yihui Xie (2014) knitr: A Comprehensive Tool for Reproducible Research in R. In Victoria Stodden, Friedrich Leisch and Roger D. Peng, editors, Implementing Reproducible Computational Research. Chapman and Hall/CRC. ISBN 978-1466561595
}
\seealso{
Other important functions: 
\code{\link{DynareR}},
\code{\link{add_path}()},
\code{\link{import_log}()},
\code{\link{include_IRF}()},
\code{\link{run_dynare}()},
\code{\link{run_models}()},
\code{\link{set_dynare_version}()},
\code{\link{set_octave_path}()},
\code{\link{write_dyn}()},
\code{\link{write_mod}()}
}
\author{
Sagiru Mati, ORCID: 0000-0003-1413-3974, https://smati.com.ng
\itemize{
\item Yusuf Maitama Sule (Northwest) University Kano, Nigeria
\item SMATI Academy
}
}
\concept{important functions}
\keyword{documentation}
