% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/informed_elo.R
\name{informed_elo}
\alias{informed_elo}
\title{Elo-rating method informed by prior information}
\usage{
informed_elo(contestants, convention, K = 200, lambda = 100,
  initial.ranks = NULL, interactions)
}
\arguments{
\item{contestants}{A dataframe with the identities of the contestants for 
                   each study period along with the relevant data for 
                   adding them to the hierarchy. There should be one row per
                   contestant per study period.
                   Periods should appear in chronological order.
                   The dataframe should contain the following columns: 
                   \describe{
                     \item{period}{Study period.}
                     \item{id}{Identity of contestant.}
                     \item{convention1}{The primary convention by which new
                     individuals are added to the hierarchy. Interpretation
                     of this column varies depending on the value of the 
                     \strong{convention} argument. If \strong{convention} = none, 
                     this column is optional.}
                     \item{convention2}{Optional. The secondary data for 
                     resolving ties in convention1. Interpretation
                     of this column varies depending on the value of the 
                     \strong{convention} argument.}
}}

\item{convention}{A flag determining how new individuals are added to the
hierarchy. The value of this flag influences how the convention1
and convention2 columns of the \strong{contestants} argument are interpreted.
Currently this function supports five options:
\describe{
 \item{none}{The standard Elo-rating procedure is run. 
 Individuals joining the hierarchy receive a score equal to 
 the mean of other group members.}
 \item{mri}{New contestants are added to the hierarchy
 according to maternal rank inheritance with youngest
 ascendancy. \strong{convention1} should be a vector of 
 mother identities for each contestant. \strong{convention2}
 should be an optional vector of intra-litter ranks (lower 
 numbers = higher rank) for resolving the order of 
 contestants from the same mother
 joining the hierarchy in the same study period.}
 \item{tenure}{New contestants are added to the hierarchy
 according their tenure in the group. \strong{convention1} should be a vector of 
 dates on which each contestant joined the group. \strong{convention2} should be an
 optional vector of numerical data for resolving ties
 in convention1 (e.g., body size). Higher values are 
 considered higher rank.}
 \item{age}{New contestants are added to the hierarchy
 according their age (older = higher rank).
 \strong{convention1} should be a vector of birthdates or 
 numerical age classes. \strong{convention2} should be an
 optional vector of numerical data for resolving ties
 in convention1 (e.g., body size). Higher values are 
 considered higher rank.}
 \item{phys_attr}{New contestants are added to the hierarchy
 according to some physical attribute (larger value = higher rank). 
 \strong{convention1} should be a vector of numerical attribute
 measurements. \strong{convention2} should be an
 optional vector of numerical data for resolving ties
 in convention1. Higher values are 
 considered higher rank.}
}}

\item{K}{Parameter influencing the magnitude of score changes after each outcome.}

\item{lambda}{Parameter influencing the shape of the logistic function
linking the difference in score between winner and loser 
to the expected probability of each contestant winning.}

\item{initial.ranks}{The initial ordering of individuals for the first study
period. Required if using maternal rank inheritance as the convention.
For other conventions, if initial.ranks is not specified,
 the order determined by convention1 is used to create the initial order.}

\item{interactions}{A dataframe of interaction data with the following columns:
\describe{
 \item{winner}{Identities of winners.}
 \item{loser}{Identities of losers.}
 \item{period}{Study period in which interactions occurred.}}}
}
\value{
Produces a dataframe with the following columns: 
         \describe{
         \item{period}{Study period.}
         \item{id}{Identity of contestant.}
         \item{score}{Elo-rating score of contestant.}
         \item{rank}{Ordinal rank of contestant in study period. Lower numbers
         equal higher rank.}
         \item{stan.rank}{Rank of contestant standardized for group size.
         Values range from 1 (highest rank) to -1 (lowest rank).}
         \item{old.order}{Identity of contestants arranged in the previous order (the order they
         were in before updating the order based on observations from current
         study period).}}
}
\description{
Use Elo-rating method to infer a dominance hierarchy over multiple study periods.
New contestants are added according to the convention specified by the user. 
Full description of the addition of new individuals is described
in Strauss & Holekamp (in revision). To run the original Elo-rating procedure,
use convention flag 'none'.
}
\examples{
##Informed elo
female.ranks <- informed_elo(contestants = C.crocuta.female$contestants, convention = 'mri',
initial.ranks = C.crocuta.female$initial.ranks,
interactions = C.crocuta.female$interactions)

##Standard elo
female.ranks <- informed_elo(contestants = C.crocuta.female$contestants, convention = 'none',
interactions = C.crocuta.female$interactions)

}
\references{
Strauss ED & Holekamp KE (in revision). Journal of Animal Ecology.
  
            Albers PCH & de Vries H (2000). Animal Behavior.
}
