% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differences.R
\name{DurgaDiff.formula}
\alias{DurgaDiff.formula}
\title{Formula interface for estimating group mean differences}
\usage{
\method{DurgaDiff}{formula}(x, data = NULL, id.col, ...)
}
\arguments{
\item{x}{a formula, such as \code{y ~ grp},
where \code{y} is a numeric vector of data values to be split into groups
according to the grouping variable \code{grp} (usually a categorical
value).}

\item{data}{a data.frame (or list) from which the variables in formula should be taken.}

\item{id.col}{Specify for paired data/repeated measures only. Name or index
of ID column for repeated measures/paired data. Observations for the same
individual must have the same ID. For non-paired data, do not specify an
\code{id.col}, (or use \code{id.col = NA}).}

\item{...}{
  Arguments passed on to \code{\link[=DurgaDiff.default]{DurgaDiff.default}}
  \describe{
    \item{\code{groups}}{Vector of group names. Defaults to all groups in \code{data} in
\emph{natural} order. If \code{groups} is a named vector, the names are
used as group labels for plotting or printing.}
    \item{\code{contrasts}}{Specify the pairs of groups to be compared. By default, all
pairwise differences are generated. May be a single string, a vector of
strings, or a matrix. Specify \code{NULL} to avoid calculating any
contrasts. See Details for more information.}
    \item{\code{effect.type}}{Type of group difference to be estimated. Possible types
are: \code{"mean"}, difference in unstandardised group means;
\code{"cohens"}, Cohen's d; \code{"hedges"}, Hedges' g; or a function. See
Details for further information.}
    \item{\code{R}}{The number of bootstrap replicates. The default value of 1000 may
need to be increased for large sample sizes; if \code{R <= nrow(x)}, an
error such as "Error in bca.ci... estimated adjustment 'a' is NA" will be
thrown.}
    \item{\code{boot.params}}{Optional list of additional names parameters to pass to
the \code{\link[boot]{boot}} function.}
    \item{\code{ci.conf}}{Numeric confidence level of the required confidence interval,
e.g. \code{ci.conf = 0.95} specifies that 95\% confidence intervals should
be calculated. Applies to both CI of effect sizes and CI of group means.}
    \item{\code{boot.ci.params}}{Optional list of additional names parameters to pass to
the \code{\link[boot]{boot.ci}} function.}
    \item{\code{na.rm}}{a logical evaluating to TRUE or FALSE indicating whether NA
values should be stripped before the computation proceeds. If \code{TRUE}
for "paired" data (i.e. \code{id.col} is specified), all rows
(observations) for IDs with missing data are stripped.}
  }}
}
\value{
A \code{DurgaDiff} object, which is a list containing:

  \item{\code{group.statistics}}{Matrix with a row for each group, columns
  are: \code{mean}, \code{median}, \code{sd} (standard deviation), \code{se}
  (standard error of the mean), \code{CI.lower} and \code{CI.upper} (lower
  and upper confidence intervals of the mean, confidence level as set by the
  \code{ci.conf} parameter) and \code{n} (group sample size)}

  \item{\code{group.differences}}{List of \code{DurgaGroupDiff} objects,
  which are \code{boot} objects with added confidence interval information.
  See \code{\link[boot]{boot}} and \code{\link[boot]{boot.ci}}. This element will be missing
  if \code{contrasts} is empty or \code{NULL}}

  \item{\code{groups}}{Vector of group names}
  \item{\code{group.names}}{Labels used to identify groups}
  \item{\code{effect.type}}{Value of \code{effect.type} parameter}
  \item{\code{effect.name}}{Pretty version of \code{effect.type}}
  \item{\code{data.col}}{Value of \code{data.col} parameter; may be an index
  or a name} \item{\code{data.col.name}}{Name of the \code{data.col} column}
  \item{\code{group.col}}{Value of \code{group.col} parameter; may be an
  index or a name} \item{\code{group.col.name}}{Name of the \code{group.col}
  column} \item{\code{id.col}}{Value of \code{id.col} parameter. May be
  \code{NULL}} \item{\code{paired.data}}{\code{TRUE} if paired differences
  were estimated} \item{\code{data}}{The input data frame}
  \item{\code{call}}{How this function was called}

  A \code{DurgaGroupDiff} object is a \code{boot} object (as returned by
  \code{\link[boot]{boot}}) with added \code{bootci} components (as returned
  by \code{\link[boot]{boot.ci}}) and components identifying the groups used
  to estimate the difference. Particularly relevant members are:

  \item{\code{t0}}{The observed value of the statistic}
  \item{\code{bca[4]}}{The lower endpoint of the confidence interval}
  \item{\code{bca[5]}}{The upper endpoint of the confidence interval}
  \item{\code{groups}}{The difference is estimated on \code{groups[1]} -
  \code{groups[2]}}
}
\description{
Estimates differences between groups in preparation for plotting by
\code{\link{DurgaPlot}}. Applies the formula, \code{x}, and a data set,
\code{data}, to construct a data frame that is then passed, with all
remaining arguments, to the function \code{\link{DurgaDiff.default}}.
}
\details{
If \code{x} is a \code{data.frame} (or similar), it must be in \emph{long
format}: one column (\code{data.col}) contains the measurement or value to be
compared, and another column (\code{group.col}) the group identity. For
repeated measures/paired data, a subject identity column (\code{id.col}) is
also required. Alternatively, \code{x} may be a formula; see
\code{\link{DurgaDiff.formula}}.

The pairs of groups to be compared are defined by the parameter
\code{contrasts}. An asterisk (\code{"*"}, the default) creates contrasts for
all possible pairs of groups. A single string has a format such as
\code{"group1 - group2, group3 - group4"}. A single string such as \code{".-
control"} compares all groups against the \code{"control"} group, i.e. the
\code{"."} expands to all groups except the named group. A vector of strings
looks like \code{c("group1 - group2", "group3 - group4")}. If a matrix is
specified, it must have a column for each contrast, with the first group in
row 1 and the second in row 2.

The formulae for Cohen's d and Hedges' g are from Lakens (2013), equations 1
and 4 respectively. The Cohen's d we use is labelled
\emph{\out{d<sub>s</sub>}} by Lakens (2013). Hedges' g is a corrected version
of Cohen's d, and is more suitable for small sample sizes. For paired (i.e.
repeated measures) Cohen's d, we apply equation 6 (Lakens 2013). For paired
Hedges' g, we apply Hedges' correction to the paired Cohen's d.

Alternative effect types can be estimated by passing a function for
\code{effect.type}. For unpaired data, the function must accept two
parameters: the values from the two groups to be compared (group 2 and group
1), and return a single numeric value, the effect size. For paired data, the
function must accept a single argument; a vector of group 1 values - group 2
values, and return a single numeric value.

Confidence intervals for the estimate are determined using bootstrap
resampling, using the adjusted bootstrap percentile (BCa) method (see
\code{\link[boot]{boot}} and \code{\link[boot]{boot.ci}}). Additional
arguments can be passed to the \code{\link[boot]{boot}}
(\code{\link[boot]{boot.ci}}) by passing a named list of values as the
argument \code{boot.params} (\code{boot.ci.params}).
}
\examples{

d <- DurgaDiff(sugar ~ treatment, insulin, id.col = "id")
print(d)

}
\references{
Lakens, D. (2013). Calculating and reporting effect sizes to facilitate
cumulative science: a practical primer for t-tests and ANOVAs. Frontiers in
Psychology, 4. doi:10.3389/fpsyg.2013.00863
}
\seealso{
\code{\link{DurgaDiff.default}}, \code{\link[boot]{boot}},
  \code{\link[boot]{boot.ci}}, \code{\link{DurgaPlot}}
}
