% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateIngredientCohortSet.R
\name{generateIngredientCohortSet}
\alias{generateIngredientCohortSet}
\title{Generates a cohort of the drug use of a certain list of concepts.}
\usage{
generateIngredientCohortSet(
  cdm,
  name,
  ingredient = NULL,
  durationRange = c(1, Inf),
  imputeDuration = "none",
  gapEra = 0,
  priorUseWashout = 0,
  priorObservation = 0,
  cohortDateRange = as.Date(c(NA, NA)),
  limit = "all",
  doseForm = NULL,
  ingredientRange = c(1, Inf)
)
}
\arguments{
\item{cdm}{A cdm_reference object.}

\item{name}{Name of the GeneratedCohortSet}

\item{ingredient}{Names of ingredients of interest. For example, c("acetaminophen",
"codeine"), would result in a list of length two with the descendant
concepts for these two particular drug ingredients.}

\item{durationRange}{Range between the duration must be comprised. It should
be a numeric vector of length two, with no NAs and the first value should be
equal or smaller than the second one. It is only required if imputeDuration
= TRUE. If NULL no restrictions are applied.}

\item{imputeDuration}{Whether/how the duration should be imputed
"none", "median", "mean", "mode", or it can be a count}

\item{gapEra}{Number of days between two continuous exposures to be
considered in the same era.}

\item{priorUseWashout}{Prior days without exposure.}

\item{priorObservation}{Minimum number of days of prior observation
required for the incident eras to be considered.}

\item{cohortDateRange}{Range for cohort_start_date and cohort_end_date}

\item{limit}{Choice on how to summarise the exposures. There are
two options:
"all" we summarise the output will be a summary of the exposed eras of
each individual. Each individual can contribute multiple times.
"first" we only consider the first observable era of each individual that fulfills the criteria provided
in previous parameters. In this case each individual can not contribute with multiple rows.}

\item{doseForm}{Only descendants codes with the specified dose form
will be returned. If NULL, descendant codes will be returned regardless
of dose form.}

\item{ingredientRange}{Used to restrict descendant codes to those
associated with a specific number of ingredients. Must be a vector of length
two with the first element the minimum number of ingredients allowed and
the second the maximum. A value of c(2, 2) would restrict to only concepts
associated with two ingredients.}
}
\value{
The function returns the 'cdm' object with the created cohorts as
references of the object.
}
\description{
Generates a cohort of the drug use of a certain list of concepts.
}
\examples{
\donttest{
library(DrugUtilisation)
cdm <- mockDrugUtilisation()
cdm <- generateIngredientCohortSet(
  cdm = cdm,
  ingredient = "acetaminophen",
  name = "test"
)
cdm
}

}
