% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/executeChecks.R
\name{executeChecks}
\alias{executeChecks}
\title{Execute all checks on Drug Exposure.}
\usage{
executeChecks(
  cdm,
  ingredients = c(1125315),
  subsetToConceptId = NULL,
  checks = c("missing", "exposureDuration", "quantity"),
  minCellCount = 5,
  sample = 10000,
  tablePrefix = NULL,
  earliestStartDate = "2010-01-01",
  verbose = FALSE
)
}
\arguments{
\item{cdm}{CDMConnector reference object}

\item{ingredients}{vector of ingredients, by default: acetaminophen}

\item{subsetToConceptId}{vector of concept IDs of the ingredients
to subset down to. If NULL, all concept IDs for an ingredient will be
considered.}

\item{checks}{the checks to be executed, by default the missing values, the
exposure duration and the quantity.}

\item{minCellCount}{minimum number of events to report- results
lower than this will be obscured. If NULL all results will be reported.}

\item{sample}{the number of samples, default 10.000}

\item{tablePrefix}{The stem for the permanent tables that will
be created when running the diagnostics. Permanent tables will be created using
this prefix, and any existing tables that start with this will be at risk of
being dropped or overwritten. If NULL, temporary tables will be
used throughout.}

\item{earliestStartDate}{the earliest date from which a record can be included}

\item{verbose}{verbose, default FALSE}
}
\value{
named list with results
}
\description{
Execute all checks on Drug Exposure.
}
\examples{
\dontrun{
db <- DBI::dbConnect(" Your database connection here ")
cdm <- CDMConnector::cdm_from_con(
  con = db,
  cdm_schema = "cdm schema name"
)
result <- executeChecks(
  cdm = cdm,
  ingredients = c(1125315))
}
}
