% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{dramaNames}
\alias{dramaNames}
\title{Format drama titles}
\usage{
dramaNames(x, ids = NULL, formatString = "\%A: \%T (\%DM)", orderBy = "drama")
}
\arguments{
\item{x}{The QDDrama object}

\item{ids}{If specified, should be a character vector of play ids (prefixed with corpus). 
Then the return value only contains the plays in the vector and in the order specified.}

\item{formatString}{A character vector. Contains special symbols that
are replaced by meta data entries about the plays. The following symbols can
be used:
- \%T: title of the play
- \%A: Author name 
- \%P: GND entry of the author (if known)
- \%DR, %DP, %DW: Date of premiere, print or written
- \%DM: The minimal date 
- \%L: The language
- \%I: The id
- \%C: The corpus prefix}

\item{orderBy}{The meta data key that the final list will be ordered by}
}
\value{
Character vector of formatted drama names
}
\description{
Given a QDDrama object, this function generates a list of nicely 
formatted names, following the format string.
}
