% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul.R
\name{histoProj}
\alias{histoProj}
\title{Project a set of curves onto a histogram basis}
\usage{
histoProj(X, t, t.range, breaks)
}
\arguments{
\item{X}{a matrix}

\item{t}{a matrix of observation times}

\item{t.range}{a range of times in which to place the P projections (default = c(0, 1000))}

\item{breaks}{the number of intervals in the histogram basis}
}
\value{
X.proj the matrix X after projection

X.count a matrix containing the number of observations used to build the projection onto the histogram basis

windows a vector containing the first time of each window of the histogram intervals

X.max the matrix of minimum values in each window

X.min the matrix of maximum values in each window
}
\description{
Project a set of curves onto a histogram basis
}
\examples{
res <- drbats.simul(N = 5, P = 100, t.range = c(5, 100), breaks = 8)
res.proj <- histoProj(res$X, res$t.simul, t.range = c(5, 100), breaks = 8)
res.proj

}
\author{
Gabrielle Weinrott
}
