% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KS2gof.R
\name{KS2gof}
\alias{KS2gof}
\title{Two-Sample Kolmogorov–Smirnov Test with Bootstrap}
\usage{
KS2gof(
  x,
  y,
  alternative = c("two.sided", "less", "greater"),
  nboots = 5000,
  keep.boots = FALSE
)
}
\arguments{
\item{x, y}{Numeric vectors of data values for the two independent samples.}

\item{alternative}{Character string specifying the alternative hypothesis,
must be one of \code{"two.sided"}, \code{"less"}, or \code{"greater"}.}

\item{nboots}{Number of bootstrap resamples used to approximate the null distribution (default: 5000).}

\item{keep.boots}{Logical; if \code{TRUE}, return the vector of bootstrap statistics.}
}
\value{
An object of class \code{"htest"} with the following components:
\describe{
  \item{statistic}{The observed KS statistic.}
  \item{p.value}{The p-value based on the bootstrap distribution.}
  \item{alternative}{The alternative hypothesis.}
  \item{method}{Description of the test used.}
}
}
\description{
Performs a two-sample Kolmogorov–Smirnov (KS) test using a bootstrap method
to assess whether two independent samples come from the same distribution.
}
\details{
This implementation performs a nonparametric KS test for equality of distributions
by resampling under the null hypothesis. It supports one-sided and two-sided alternatives.

If \code{keep.boots = TRUE}, the function returns all bootstrap statistics,
which can be used for further analysis (e.g., plotting).

If the p-value is zero due to no bootstrap statistic exceeding the observed value,
it is adjusted to \code{1 / (2 * nboots)} to avoid a zero p-value.
}
\examples{
set.seed(123)
x <- rnorm(100, mean = 0, sd = 4)
y <- rnorm(100, mean = 2, sd = 4)
KS2gof(x, y)

}
