% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_groups_by_minsize.R
\name{filter_groups_by_minsize}
\alias{filter_groups_by_minsize}
\title{Filter Group by Size}
\usage{
filter_groups_by_minsize(clusterised_object, min_group_size)
}
\arguments{
\item{clusterised_object}{An object created by the clusterise_sites functions.}

\item{min_group_size}{The minimum size of each group.}
}
\value{
A new clusterised object with groups of at least the specified minimum size.
}
\description{
Filter a clusterised object by removing groups below a specified size.
}
\examples{
# return groups that have at least 10 sites

Colombia_Huila_dataframe <- subset(Colombia, stateProvince == "Huila")

clusterised_Huila <- clusterise_sites(dataframe = Colombia_Huila_dataframe,
                                      cluster_min_length = 30,
                                      group_radius = 20000
)

clusterised_Huila_largegroups <-
  filter_groups_by_minsize(

    clusterised_object = clusterised_Huila,
    min_group_size = 10

)

print(clusterised_Huila_largegroups[[2]])

}
