% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divfit.R
\name{divfit}
\alias{divfit}
\title{Distributional IV Model Fit Function}
\usage{
divfit(
  Z,
  X,
  Y,
  W,
  epsx_dim = epsx_dim,
  epsy_dim = epsy_dim,
  epsh_dim = epsh_dim,
  hidden_dim = hidden_dim,
  num_layer = num_layer,
  num_epochs = num_epochs,
  lr = lr,
  beta = beta,
  silent = silent
)
}
\arguments{
\item{Z}{A data frame, matrix, vector, or factor variable representing the instrumental variable.}

\item{X}{A data frame, matrix, vector, or factor variable representing the predictor.}

\item{Y}{A data frame, matrix, vector, or factor variable representing the target variable.}

\item{W}{(Optional) A data frame, matrix, vector, or factor variable representing the exogenous variable(s).}

\item{epsx_dim}{The dimension of the noise corresponding to the predictor introduced in the model (default: 50).}

\item{epsy_dim}{The dimension of the noise corresponding to the outcome introduced in the model (default: 50).}

\item{epsh_dim}{The dimension of the noise corresponding to the hidden confounder introduced in the model (default: 50).}

\item{hidden_dim}{The size of the hidden layer in the model (default: 100).}

\item{num_layer}{The number of layers in the model (default: 3).}

\item{num_epochs}{The number of epochs to be used in training (default: 1000).}

\item{lr}{The learning rate to be used in training (default: 10^-3).}

\item{beta}{The beta scaling factor for energy loss, numeric value from (0,2) (default: 1).}

\item{silent}{A boolean indicating whether to suppress output during model training (default: FALSE).}
}
\value{
A list containing the trained DIV model and a matrix of loss values.
}
\description{
This function fits a joint distributional IV model to the provided data. It allows for the tuning of
several parameters related to model complexity and model training. The function is not meant to
be exported but can be used within the package or for internal testing purposes.
}
\keyword{internal}
