% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariateMOCopula.R
\name{bivariateMO}
\alias{bivariateMO}
\alias{cBivariateMO}
\alias{crBivariateMO}
\title{Bivariate Marshall-Olkin Copula}
\usage{
cBivariateMO(u1, u2, dependencyParameter, ...)

crBivariateMO(numberSimulations = 10000, seed = 42, dependencyParameter)
}
\arguments{
\item{u1, u2}{points at which to evaluate the copula.}

\item{dependencyParameter}{correlation parameters, must be vector of length 2.}

\item{...}{other parameters.}

\item{numberSimulations}{Number of simulations.}

\item{seed}{Simulation seed, 42 by default.}
}
\value{
Function :
  \itemize{
    \item{\code{\link{cBivariateMO}}}{ returns the value of the copula.}
    \item{\code{\link{crBivariateMO}}}{ returns simulated values of the copula.}
  }
}
\description{
Computes CDF and simulations of the bivariate Marshall-Olkin copula.
}
\details{
The bivariate Marshall-Olkin copula has CDF :
  \deqn{C(u_{1}, u_{2}) = u_{1}u_{2}^{1 - \beta} \times%
    \textbf{1}_{\{u_{1}^{\alpha} \leq u_{2}^{\beta}\}} + %
    u_{1}^{1 - \alpha}u_{2} \times \textbf{1}_{\{u_{1}^{\alpha}%
    \geq u_{2}^{\beta}\}}}{C(u1, u2) = u1 u2^(1 - beta) * %
    1_(u1^alpha <= u2^beta) + u1^(1 - alpha) u2 * 1_(u1^alpha >= u2^beta}
for \eqn{u_{1}, u_{2}, \alpha, \beta \in [0, 1]}{0 <= u1, u2, alpha, beta <= 1}.
It is the geometric mean of the independance and upper Fréchet bound copulas.
}
\examples{
cBivariateMO(u1 = .76, u2 = 0.4, dependencyParameter = c(0.4, 0.3))

crBivariateMO(numberSimulations = 10, seed = 42, dependencyParameter = c(0.2, 0.5))

}
