% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcDissim.R
\name{distBetPairs}
\alias{distBetPairs}
\title{Calculate Distance  Between Attribute Values.}
\usage{
distBetPairs(myDataAll)
}
\arguments{
\item{myDataAll}{A data frame which includes qualitative variables OR discretized quantitative variables
OR a mixture of qualitative variables and discretized quantitative variables in columns.}
}
\value{
A data frame with four columns J, A, B and C in columns where Distance(A, B) = C
and J is the column number in the input data frame corresponding to the values in A.
}
\description{
Takes in a data frame which contains only qualitative variables. Discretized quantitative variables
, a mixture of qualitative variables and discretized quantitative variables are also accepted.
Calculates distance between each pair of attribute values for a given attribute. This calculation
is done according to the method proposed by Ahmad & Dey (2007).
}
\details{
distBetPairs is an implementtion of the method proposed by Ahmad & Dey (2007)
to find the distance between two catogorical values corresponding to a qualitative
variable. This distance measure considers distribution of values in the data set.
This function is also used to find the distance between discretized values
corresponding to quantitative variables which are used in calculating the significance
of quantitative attributes. See Ahmad & Dey (2007) for more datails.
}
\examples{
QualiVars <- data.frame(Qlvar1 = c("A","B","A","C"), Qlvar2 = c("Q","Q","R","Q"))
library(dplyr)
distForQuali <- distBetPairs(QualiVars)
QuantVars <- data.frame(Qnvar1 = c(1.5,3.2,4.9,5), Qnvar2 = c(4.8,2,1.1,5.8))
Discretized <- discretizeQuant(QuantVars)
distForQuant <- distBetPairs(Discretized)
AllQualQuant <- data.frame(QualiVars, Discretized)
distForAll <- distBetPairs(AllQualQuant)
}
\references{
Ahmad, A., & Dey, L. (2007). A k-mean clustering algorithm for mixed numeric and categorical data. Data & Knowledge Engineering, 63(2), 503-527.
}

