esag.datacontour <- function(x, lat = 20, long = 20) {
  ## x contains the data in latitude and longitude
  ## the first column is the latitude and the
  ## second column is the longitude
  ## if x are Euclidean coordinates turn them into
  ## latitude and longitude
  dm <- dim(x)
  if ( dm[2] == 3 ) {
    u <- Directional::euclid.inv(x)
  } else if ( dm[2] == 2 ) {
    u <- x
    x <- Directional::euclid(x) ## Euclidean coordinates used by Kent (1982)
  }

  a <- Directional::esag.mle(x) ## MLE estimation of the Kent distribution
  mu <- a$mu ## the mean direction
  gam <- a$gam ## the gamma parameters
  n <- 100
  x1 <- seq(min(u[, 1]) - lat, max(u[, 1]) + lat, length = n)  ## latitude
  x2 <- seq(min(u[, 2]) - long, max(u[, 2]) + long, length = n)  ## longitude

  wa <- NULL
  for ( i in 1:n )  wa <- rbind(wa, Directional::euclid( cbind(x1[i], x2) ) )
  can <- Directional::desag(wa, a$mu, a$gam, logden = FALSE)
  mat <- matrix(can, nrow = n, ncol = n, byrow = TRUE)

  # Continuous color legend
  # Note that it disappears EVERY BLACK LINE!!!!!!
  # So, for the ones you want, you must do col = "black"
  # For more, see here
  # https://stackoverflow.com/questions/8068366/removing-lines-within-filled-contour-legend
  par(fg = NA)
  # Filled contoure plot in base R
  filled.contour(x1, x2, mat,
                 # Number of levels
                 # the greater the more interpolate
                 nlevels = 200,
                 # Select color function
                 color.palette = colorRampPalette( c( "blue",
                                                      "cyan",
                                                      "yellow",
                                                      "red") ),
                 # Adjust axes to points
                 plot.axes = {
                 # Add points
                 points(u[, 1], u[, 2], col = "black", pch = 16);
                 # Add contour lines
                 contour(x1, x2, mat,
                 # Color of contour lines
                 # Otherwise par(fg = NA) will disappear them...
                 col = "black",
                 # Number of levels
                 nlevels = 10,
                 # Size of contour numbers
                 labcex = 0.8,
                 # Width of contour lines
                 lwd = 1.5,
                 add = TRUE) },
                 # Legend tick lines
                 key.axes = {axis(4, col = "black", cex.lab = 1.2)},
                 # Axes labs
                 xlab = "Latitude",
                 ylab = "Longitude",
                 cex.lab = 1.2)
}
