% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmf.R
\name{vmf}
\alias{vmf}
\alias{kappa_ml}
\alias{mu_ml}
\alias{d_mixvmf}
\title{Von Mises--Fisher distribution utilities}
\usage{
kappa_ml(data)

mu_ml(data)

d_mixvmf(x, mu, kappa, p, norm = FALSE)
}
\arguments{
\item{data}{directional data, a matrix of size \code{c(n, q + 1)}.}

\item{x}{evaluation points, a matrix of size \code{c(nx, q + 1)}.}

\item{mu, kappa, p}{mixture parameters. \code{mu} is the mean matrix of size
\code{c(length(p), q + 1)}, \code{kappa} is vector of \code{length(p)}
concentration parameters, and \code{p} is the vector of mixture proportions.}

\item{norm}{enforce normalization of \code{x} internally? Defaults
to \code{FALSE}.}
}
\value{
Estimated vector mean (\code{mu_ml}) or concentration parameter
(\code{kappa_ml}). A vector of length \code{nx} for \code{d_mixvmf}.
}
\description{
Maximum likelihood estimation for the von Mises--Fisher
distribution and evaluation of density mixtures.
}
\examples{
# Sample
n <- 50
q <- 2
samp <- rotasym::r_vMF(n = n, mu = c(1, rep(0, q)), kappa = 2)

# Estimates
mu_ml(samp)
kappa_ml(samp)

# Mixture
x <- to_cir(seq(0, 2 * pi, l = 200))
dens <- d_mixvmf(x = x, mu = rbind(c(-1, 0), c(0, 1), c(1, 0)),
                 kappa = 1:3, p = c(0.5, 0.2, 0.3))
plot(to_rad(x), dens, type = "l")
}
