\name{RS.estimates}
\alias{RS.estimates}
\title{
Extract Parmaeter Estimates from \code{.impute()} Objects.
}
\description{
\code{RS.estimates()} calculates parameter estimates from \code{.impute()} model objects.
}
\usage{
RS.estimates(x, thin = 100, burns, CI = c(0.05, 0.95), corrmat = FALSE, 
             acf.plot = TRUE, palette = 'mono')
}

\arguments{
  \item{x}{List object of type 'RS.impute' or 'BiRS.impute'. That is, when \code{model = RS.impute()} then \code{model} constitutes an appropriate object for \code{x}.
}
  \item{thin}{
Thinnging level for parameter chain.
}
  \item{burns}{
Number of MCMC updates to discard before calculating estimates.
}
 \item{CI}{
Credibility interval quantiles (for MCMC chains).
}

  \item{corrmat}{
If TRUE, an estimated correlation matrix is returned in addition to the estimate vector.
}
  \item{acf.plot}{
If TRUE, an acf plot is drawn for each element of the parameter chain.
}
\item{palette}{Colour palette for drawing trace plots. Default \code{palette = 'mono'}, otherwise a qualitative palette will be used.}
}

\value{
Data frame with parameter estimates and appropriate interval statistics.
}

\author{
Etienne A.D. Pienaar: \email{etiannead@gmail.com}
}
\references{
Updates available on GitHub at \url{https://github.com/eta21}.
}
\examples{
\donttest{
example(RS.impute)
}
}
\seealso{
\code{\link{RS.impute}},  \code{\link{BiRS.impute}}.
}

