\name{sectionview.list}
\alias{sectionview.list}
\title{Plot a section view of a model, including design points}
\usage{
  sectionview.list(model, center = NULL, axis = NULL,
    npoints = 100, col_points = "red", col_surf = "blue",
    bg_blend = 5, mfrow = NULL, Xname = NULL, yname = NULL,
    Xscale = 1, yscale = 1, xlim = NULL, ylim = NULL,
    title = NULL, add = FALSE, ...)
}
\arguments{
  \item{model}{a list that can be used as model with the
  \code{modelPredict} function of the \pkg{DiceEval}
  package.}

  \item{center}{optional coordinates (as a list or data
  frame) of the center of the section view if the model's
  dimension is > 1.}

  \item{axis}{optional matrix of 1-axis combinations to
  plot, one by row. The value \code{NULL} leads to all
  possible combinations i.e. \code{1:D}.}

  \item{npoints}{an optional number of points to discretize
  plot of response surface and uncertainties.}

  \item{col_points}{color of points.}

  \item{col_surf}{color for the section.}

  \item{bg_blend}{an optional factor of alpha (color
  channel) blending used to plot design points outside from
  this section.}

  \item{mfrow}{an optional list to force \code{par(mfrow =
  ...)} call. Default (NULL value) is automatically set for
  compact view.}

  \item{xlim}{an optional list to force x range for all
  plots. The default value \code{NULL} is automatically set
  to include all design points.}

  \item{ylim}{an optional list to force y range for all
  plots. The default value \code{NULL} is automatically set
  to include all design points.}

  \item{Xname}{an optional list of string to overload names
  for X.}

  \item{yname}{an optional string to overload name for y.}

  \item{Xscale}{an optional factor to scale X.}

  \item{yscale}{an optional factor to scale y.}

  \item{title}{an optional overload of main title.}

  \item{add}{to print graphics on an existing window.}

  \item{\dots}{optional arguments passed to the first call
  of plot().}
}
\description{
  Plot one section view per dimension of a surrogate model.
  It is useful for a better understanding of a model
  behaviour.
}
\details{
  A multiple rows/columns plot is produced. Experimental
  points are plotted with fading colors. Points that fall
  in the specified section (if any) have the color
  specified \code{col_points} while points far away from
  the center have shaded versions of the same color. The
  amount of fading is determined using the Euclidean
  distance between the plotted point and \code{center}.
}
\examples{
## A 2D example: Branin-Hoo function. See the DiceKriging package manual
## a 16-points factorial design, and the corresponding response
d <- 2; n <- 16
design.fact <- expand.grid(seq(0, 1, length = 4), seq(0, 1, length = 4))
design.fact <- data.frame(design.fact); names(design.fact) <- c("x1", "x2")
y <- branin(design.fact)

## linear model
m1 <- modelFit(design.fact, y$x1, type = "Linear", formula = "Y~.")

sectionview.list(m1, center = c(.333,.333))
}
\author{
  Yann Richet, IRSN
}
\seealso{
  See \code{\link{sectionview3d.list}} for a 3d version,
  and the \code{\link[DiceEval]{modelPredict}} function in
  the \pkg{DiceEval} package.
}
\keyword{models}

