% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_s_connected_cmpts.R
\name{get_s_connected_cmpts}
\alias{get_s_connected_cmpts}
\title{Get nodes within strongly connected components}
\usage{
get_s_connected_cmpts(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a data frame with nodes and their membership
in different strongly connected components.
}
\description{
Determine which nodes in a graph belong
to different strongly connected components.
}
\examples{
set.seed(23)

# Create a graph with a random
# connection between 2 different
# node cycles
graph <-
  create_graph() \%>\%
  add_cycle(
    n = 3,
    type = "cycle_1") \%>\%
  add_cycle(
    n = 4,
    type = "cycle_2") \%>\%
  add_edge(
    from =
      get_node_ids(
        graph = .,
        conditions =
          type == "cycle_1") \%>\%
        sample(size = 1),
    to =
      get_node_ids(
        graph = .,
        conditions =
          type == "cycle_2") \%>\%
        sample(size = 1))

# Get the strongly connected
# components as a data frame of
# nodes and their groupings
graph \%>\%
  get_s_connected_cmpts()
}
