% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiSCo_CI.R
\name{DiSCo_CI}
\alias{DiSCo_CI}
\title{DiSCo_CI}
\usage{
DiSCo_CI(
  controls,
  weights,
  mc.cores = 1,
  cl = 0.95,
  num.redraws = 500,
  evgrid = seq(from = 0, to = 1, length.out = 1001),
  qmethod = NULL
)
}
\arguments{
\item{controls}{A list containing the raw data for the control group}

\item{weights}{A vector of optimal weights}

\item{mc.cores}{Number of cores to use for parallelization}

\item{cl}{Numeric, confidence level for the (two-sided) confidence intervals.}

\item{num.redraws}{The number of bootstrap samples to draw}

\item{qmethod}{Character, indicating the method to use for computing the quantiles of the target distribution. The default is NULL, which uses the \code{\link[stats]{quantile}} function from the stats package.
Other options are "\code{\link[evmix]{qkden}}" (based on smoothed kernel density function) and "\code{\link[extremeStat:distLquantile]{extreme}}" (based on parametric extreme value distributions).
Both are substantially slower than the default method but may be useful for fat-tailed distributions with few data points at the upper quantiles. Alternatively, one could use the q_max option to restrict the range of quantiles used.}
}
\value{
\code{DSC_CI} returns a list containing the following components:
\itemize{
\item \code{upper } A vector of the upper bound.
\item \code{lower } A vector of the lower bound.
\item \code{se } A vector of the standard errors of each counterfactual quantile estimate.
\item \code{bootmat } A matrix of the counterfactual quantile estimates for each bootstrap sample.
}
}
\description{
Function for computing the confidence intervals in the DiSCo method
}
\keyword{internal}
