% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetDeltaPi.R
\name{GetDeltaPi}
\alias{GetDeltaPi}
\title{Calculate Delta and Pi parameters function}
\usage{
GetDeltaPi(mx, tp, tol = 1e-12, maxits = 1000)
}
\arguments{
\item{mx}{Matrix. Modified matrix to have a solution Usually GetMx$M2.}

\item{tp}{String. Type of problem.}

\item{tol}{Double number. Indicate the precision of the numeric method to calculate B. Expected to be 1e-6 <= tol <= 1e-15.Default is 1e-12.}

\item{maxits}{Whole number. Indicate the maximum number of iterations of the numeric method to calculate B. Expected to be 100 <= maxits <= 5000. Default is 1000.}
}
\description{
This function provide an estimation of Pi and Delta for each category. To do so, it is needed to solve the non-linear 
equation of B, given by the function GetB.
}
\details{
In some type of problems, such as "2.1" and "3.1", problem has a unique solution for Delta and infinite for Pi. For this reason
we calculate the solution for Delta and get Pi as NULL.
}
\examples{
GetDeltaPi(mx = matrix(c(1,0,0,0,2,0,0,0,3),3,3), tp = "3.1", tol = 1e-12, maxits = 1000)
GetDeltaPi(mx = matrix(c(1.5,2.5,0.5,3.5,4.5,0.5,0.5,0.5,1.5),3,3), tp = "3.2", 
           tol = 1e-12, maxits = 1000)
}
\keyword{Delta}
\keyword{maxits}
\keyword{mx}
\keyword{tol}
\keyword{tp}
