/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial;

import edu.cens.spatial.DeducerSpatial;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.widgets.RDialog;
import org.rosuda.deducer.widgets.SingleVariableWidget;
import org.rosuda.deducer.widgets.TextFieldWidget;
import org.rosuda.deducer.widgets.VariableSelectorWidget;

public class DFPointConvertDialog
extends RDialog
implements ActionListener {
    private static final String HELP_URL = "index.php?n=Main.DeducerSpatial";
    private VariableSelectorWidget variableSelector;
    private SingleVariableWidget yaxis;
    private SingleVariableWidget xaxis;
    private TextFieldWidget dataNameField;
    private static DFPointConvertDialog inst;

    public static DFPointConvertDialog getInstance() {
        if (inst == null) {
            inst = new DFPointConvertDialog();
        }
        DeducerSpatial.rgdalCheck();
        return inst;
    }

    public void initGUI() {
        super.initGUI();
        this.variableSelector = new VariableSelectorWidget();
        this.add((Component)this.variableSelector, new AnchorConstraint(12, 428, 900, 12, 2, 1, 1, 2));
        this.variableSelector.setPreferredSize(new Dimension(216, 379));
        this.variableSelector.setTitle("Data");
        this.yaxis = new SingleVariableWidget("Latitude", this.variableSelector);
        this.add((Component)this.yaxis, new AnchorConstraint(121, 978, 327, 460, 1, 1, 1, 1));
        this.yaxis.setPreferredSize(new Dimension(276, 63));
        this.xaxis = new SingleVariableWidget("Longitude", this.variableSelector);
        this.add((Component)this.xaxis, new AnchorConstraint(337, 978, 540, 460, 1, 1, 1, 1));
        this.xaxis.setPreferredSize(new Dimension(276, 63));
        this.dataNameField = new TextFieldWidget("New data name");
        this.add((Component)this.dataNameField, new AnchorConstraint(610, 978, 840, 460, 0, 1, 1, 1));
        this.dataNameField.setPreferredSize(new Dimension(187, 44));
        this.setTitle("Convert data.frame to Spatial Points");
        this.setOkayCancel(true, true, this);
        this.addHelpButton(HELP_URL);
        this.setSize(555, 445);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Run") {
            String string2 = this.xaxis.getSelectedVariable();
            String string3 = this.yaxis.getSelectedVariable();
            String string4 = this.variableSelector.getSelectedData();
            String string5 = this.dataNameField.getValidatedText();
            if (string5.length() == 0) {
                string5 = Deducer.getUniqueName((String)(string4 + ".sp"));
            }
            if (string3 == null || string2 == null || string4 == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "You must specify both an x and y variable");
                return;
            }
            String string6 = Deducer.getUniqueName((String)(string4 + "_temp"));
            Deducer.execute((String)(string6 + " <- " + string4));
            Deducer.execute((String)("if (class(" + string4 + "[, '" + string2 + "']) == 'factor') {"));
            Deducer.execute((String)(string6 + "[,'" + string2 + "'] <- as.numeric(as.character(" + string6 + "[, '" + string2 + "']))"));
            Deducer.execute((String)"}");
            Deducer.execute((String)("if (class(" + string4 + "[, '" + string3 + "']) == 'factor') {"));
            Deducer.execute((String)(string6 + "[,'" + string3 + "'] <- as.numeric(as.character(" + string6 + "[, '" + string3 + "']))"));
            Deducer.execute((String)"}");
            Deducer.execute((String)(string6 + " <- subset(" + string6 + ",  \n" + "!is.na(" + string2 + ")  & !is.na(" + string3 + ") )"));
            String string7 = string5 + " <- SpatialPointsDataFrame(" + string6 + "[,c('" + string2 + "', '" + string3 + "')], data=" + string6 + ",proj4string=CRS('+proj=longlat +datum=WGS84'))";
            string7 = string7 + "\n" + string5 + " <- spTransform(" + string5 + ",osm())";
            Deducer.execute((String)string7);
            Deducer.execute((String)("rm(" + string6 + ")"));
            this.setVisible(false);
            this.completed();
        } else if (string == "Cancel") {
            this.setVisible(false);
        } else if (string == "Reset") {
            this.reset();
        }
    }
}

