/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import java.util.ArrayList;
import java.util.List;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.util.Global;
import org.rosuda.util.ProgressDlg;
import org.rosuda.util.Stopwatch;

public class SVarFixDouble
extends SVar {
    double[] cont;
    int insertPos = 0;
    List cats;
    List ccnts;
    int[] ranks = null;

    public SVarFixDouble(String string, int n) {
        super(string, false);
        if (n < 0) {
            n = 0;
        }
        this.guessing = false;
        this.contentsType = 1;
        this.isnum = true;
        this.cont = new double[n];
    }

    public SVarFixDouble(String string, double[] dArray) {
        this(string, dArray, true);
    }

    public SVarFixDouble(String string, double[] dArray, boolean bl) {
        super(string, false);
        boolean bl2 = true;
        this.max = 0.0;
        this.min = 0.0;
        if (bl) {
            this.cont = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.cont[i] = dArray[i];
                if (Double.isNaN(this.cont[i])) {
                    ++this.missingCount;
                    continue;
                }
                if (bl2) {
                    this.min = this.max = this.cont[i];
                    bl2 = false;
                    continue;
                }
                if (this.cont[i] > this.max) {
                    this.max = this.cont[i];
                    continue;
                }
                if (!(this.cont[i] < this.min)) continue;
                this.min = this.cont[i];
            }
        } else {
            this.cont = dArray;
            for (int i = 0; i < dArray.length; ++i) {
                if (Double.isNaN(this.cont[i])) {
                    ++this.missingCount;
                    continue;
                }
                if (bl2) {
                    this.min = this.max = this.cont[i];
                    bl2 = false;
                    continue;
                }
                if (this.cont[i] > this.max) {
                    this.max = this.cont[i];
                    continue;
                }
                if (!(this.cont[i] < this.min)) continue;
                this.min = this.cont[i];
            }
        }
        this.insertPos = dArray.length;
        this.guessing = false;
        this.contentsType = 1;
        this.isnum = true;
    }

    public int size() {
        return this.cont.length;
    }

    public void categorize(boolean bl) {
        if (this.cat && !bl) {
            return;
        }
        this.cats = new ArrayList();
        this.ccnts = new ArrayList();
        this.cat = true;
        if (!this.isEmpty()) {
            int n = 0;
            while (n < this.cont.length) {
                String string = Double.isNaN(this.cont[n]) ? "NA" : Double.toString(this.cont[n]);
                int n2 = this.cats.indexOf(string);
                if (n2 == -1) {
                    this.cats.add(string);
                    this.ccnts.add(new Integer(1));
                    continue;
                }
                this.ccnts.set(n2, new Integer((Integer)this.ccnts.get(n2) + 1));
            }
            if (this.isNum()) {
                this.sortCategories(1);
            }
        }
        this.NotifyAll(new NotifyMsg(this, 12290));
    }

    public void sortCategories(int n) {
        if (!this.isCat() || this.cats.size() < 2) {
            return;
        }
        Stopwatch stopwatch = null;
        if (Global.DEBUG > 0) {
            stopwatch = new Stopwatch();
            System.out.println("Sorting variable \"" + this.name + "\"");
        }
        List list = this.cats;
        List list2 = this.ccnts;
        this.cats = new ArrayList(list.size());
        this.ccnts = new ArrayList(list2.size());
        boolean bl = true;
        int n2 = list.size();
        while (bl) {
            bl = false;
            int n3 = -1;
            double d = -0.01;
            boolean bl2 = false;
            String string = null;
            for (int i = 0; i < n2; ++i) {
                Object e = list.get(i);
                if (e == null) continue;
                if (n == 1) {
                    double d2 = -0.01;
                    try {
                        d2 = ((Number)e).doubleValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!bl2) {
                        bl2 = true;
                        d = d2;
                        n3 = i;
                        continue;
                    }
                    if (!(d2 < d)) continue;
                    d = d2;
                    n3 = i;
                    continue;
                }
                if (!bl2) {
                    bl2 = true;
                    string = e.toString();
                    n3 = i;
                    continue;
                }
                if (string.compareTo(e.toString()) <= 0) continue;
                string = e.toString();
                n3 = i;
            }
            bl = bl2;
            if (!bl) continue;
            this.cats.add(list.get(n3));
            this.ccnts.add(list2.get(n3));
            list.set(n3, null);
        }
        if (Global.DEBUG > 0) {
            stopwatch.profile("sorted");
        }
    }

    public void dropCat() {
        this.cats = null;
        this.ccnts = null;
        this.cat = false;
        this.NotifyAll(new NotifyMsg(this, 12290));
    }

    public void setCategorical(boolean bl) {
        if (!bl) {
            this.cat = false;
        } else if (this.cats == null) {
            this.categorize();
        } else {
            this.cat = true;
        }
    }

    public boolean add(Object object) {
        if (this.insertPos >= this.cont.length) {
            return false;
        }
        if (this.cacheRanks && this.ranks != null) {
            this.ranks = null;
        }
        double d = double_NA;
        if (object != null) {
            try {
                d = Double.parseDouble(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return this.add(d);
    }

    public boolean add(int n) {
        return this.add(n == int_NA ? double_NA : (double)n);
    }

    public boolean add(double d) {
        if (this.insertPos >= this.cont.length) {
            return false;
        }
        if (this.cat) {
            String string = Double.isNaN(d) ? "NA" : Double.toString(d);
            int n = this.cats.indexOf(string);
            if (n == -1) {
                this.cats.add(string);
                this.ccnts.add(new Integer(1));
            } else {
                this.ccnts.set(n, new Integer((Integer)this.ccnts.get(n) + 1));
            }
        }
        if (!Double.isNaN(d)) {
            if (d > this.max) {
                this.max = d;
            }
            if (d < this.min) {
                this.min = d;
            }
        } else {
            ++this.missingCount;
        }
        this.cont[this.insertPos++] = d;
        this.NotifyAll(new NotifyMsg(this, 12289));
        return true;
    }

    public boolean replace(int n, Object object) {
        return false;
    }

    public boolean replace(int n, double d) {
        if (n < 0 || n >= this.cont.length || this.isCat()) {
            return false;
        }
        if (Double.isNaN(this.cont[n])) {
            --this.missingCount;
        }
        this.cont[n] = d;
        if (Double.isNaN(d)) {
            ++this.missingCount;
        }
        return true;
    }

    public Object at(int n) {
        return n < 0 || n >= this.insertPos || SVarFixDouble.isNA(this.cont[n]) ? null : new Double(this.cont[n]);
    }

    public double atD(int n) {
        return n < 0 || n >= this.insertPos ? double_NA : this.cont[n];
    }

    public int atI(int n) {
        return n < 0 || n >= this.insertPos || Double.isNaN(this.cont[n]) ? int_NA : (int)(this.cont[n] + 0.5);
    }

    public String asS(int n) {
        return n < 0 || n >= this.insertPos || SVarFixDouble.isNA(this.cont[n]) ? null : Double.toString(this.cont[n]);
    }

    public int getCatIndex(Object object) {
        if (this.cats == null) {
            return -1;
        }
        Object object2 = object;
        if (object == null) {
            object2 = "NA";
        }
        return this.cats.indexOf(object2);
    }

    public int getCatIndex(int n) {
        try {
            return this.getCatIndex(this.elementAt(n));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public Object getCatAt(int n) {
        if (this.cats == null) {
            return null;
        }
        try {
            return this.cats.get(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getSizeCatAt(int n) {
        if (this.cats == null) {
            return -1;
        }
        try {
            return (Integer)this.ccnts.get(n);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getSizeCat(Object object) {
        if (this.cats == null) {
            return -1;
        }
        int n = this.cats.indexOf(object);
        return n == 1 ? -1 : (Integer)this.ccnts.get(n);
    }

    public int getNumCats() {
        if (this.cats == null) {
            return 0;
        }
        return this.cats.size();
    }

    public Object[] getCategories() {
        if (this.cats == null) {
            return null;
        }
        Object[] objectArray = new Object[this.cats.size()];
        this.cats.toArray(objectArray);
        return objectArray;
    }

    public boolean remove(int n) {
        return false;
    }

    public boolean insert(Object object, int n) {
        return false;
    }

    public int[] getRanked(SMarker sMarker, int n) {
        int n2;
        Stopwatch stopwatch = new Stopwatch();
        if (this.isCat() || !this.isNum() || this.size() == 0) {
            return null;
        }
        if (sMarker == null && this.cacheRanks && this.ranks != null) {
            return this.ranks;
        }
        int[] nArray = null;
        if (!this.cacheRanks || this.ranks == null) {
            int n3;
            ProgressDlg progressDlg = null;
            if (this.size() > 1000) {
                progressDlg = new ProgressDlg("Variable " + this.getName());
                progressDlg.begin("Calculating ranks ...");
            }
            n2 = this.size();
            nArray = new int[n2];
            double[] dArray = this.cont;
            stopwatch.profile("getRanked: pass 1: store relevant values");
            for (n3 = 0; n3 < n2; ++n3) {
                nArray[n3] = n3;
            }
            for (n3 = 0; n3 < n2 - 1; ++n3) {
                double d = dArray[nArray[n3]];
                int n4 = n2 - 1;
                if (progressDlg != null && (n3 & 0xFF) == 0) {
                    progressDlg.setProgress((int)((double)n3 * 99.0 / (double)n2));
                }
                while (n4 > n3) {
                    double d2 = dArray[nArray[n4]];
                    if (d2 < d) {
                        int n5 = nArray[n3];
                        nArray[n3] = nArray[n4];
                        nArray[n4] = n5;
                        d = d2;
                    }
                    --n4;
                }
            }
            if (progressDlg != null) {
                progressDlg.setProgress(99);
            }
            stopwatch.profile("getRanked: pass 2: sort");
            if (this.cacheRanks) {
                this.ranks = nArray;
            }
            dArray = null;
            if (progressDlg != null) {
                progressDlg.end();
            }
            progressDlg = null;
        } else {
            nArray = this.ranks;
        }
        if (sMarker != null && nArray != null) {
            int n6;
            int n7 = nArray.length;
            n2 = 0;
            for (n6 = 0; n6 < n7; ++n6) {
                if (sMarker.get(n6) != n) continue;
                ++n2;
            }
            if (n2 == 0) {
                return null;
            }
            int[] nArray2 = new int[n2];
            int n8 = 0;
            for (n6 = 0; n6 < n7; ++n6) {
                if (sMarker.get(nArray[n6]) != n) continue;
                nArray2[n8++] = nArray[n6];
            }
            nArray = null;
            nArray = nArray2;
        }
        return nArray;
    }

    public String toString() {
        return "SVarFixDouble(\"" + this.name + "\"," + (this.cat ? "cat," : "cont,") + (this.isnum ? "num," : "txt,") + "n=" + this.size() + "/" + this.cont.length + ",miss=" + this.missingCount + ")";
    }
}

