% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/declare_step.R
\name{declare_step}
\alias{declare_step}
\title{Declare a custom step}
\usage{
declare_step(
  ...,
  handler = function(data, ...f, ...) ...f(data, ...),
  label = NULL
)
}
\arguments{
\item{...}{arguments to be captured, and later passed to the handler}

\item{handler}{a tidy-in, tidy-out function}

\item{label}{a string describing the step}
}
\value{
A function that returns a data.frame.
}
\description{
With declare_step, you can include any function that takes data as one of its arguments and returns data in a design declaration. The first argument is always a "handler", which is the name of the data-in, data-out function.
For handy data manipulations use \code{declare_step(fabricate, ...)}.
}
\examples{

population <- declare_population(N = 5, noise = rnorm(N))
manipulate <- declare_step(fabricate, noise_squared = noise^2, zero = 0)

design <- population + manipulate
draw_data(design)

}
