% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_citation.R
\name{set_citation}
\alias{set_citation}
\title{Set the citation of a design}
\usage{
set_citation(
  design,
  title = NULL,
  author = NULL,
  year = NULL,
  description = "Unpublished research design declaration",
  citation = NULL
)
}
\arguments{
\item{design}{A design typically created using the + operator}

\item{title}{The title of the design, as a character string.}

\item{author}{The author(s) of the design, as a character string.}

\item{year}{The year of the design, as a character string.}

\item{description}{A description of the design in words, as a character string.}

\item{citation}{(optional) The preferred citation for the design, as a character string, in which case title, author, year, and description may be left unspecified.}
}
\value{
a design object with a citation attribute
}
\description{
Set the citation of a design
}
\examples{

design <-
declare_population(data = sleep) +
  declare_sampling(n = 10)

design <-
  set_citation(design,
               author = "Lovelace, Ada",
               title = "Notes",
               year = 1953,
               description = "This is a text description of a design")

cite_design(design)

}
