% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/value_hierarchy_tree.R
\name{value_hierarchy_tree}
\alias{value_hierarchy_tree}
\title{Value Hierarchy Tree}
\usage{
value_hierarchy_tree(..., leaves, weights, nodestyle = "filled, rounded",
  nodeshape = "box", nodefillcolor = "white", nodefontname = "helvetica",
  nodefontcolor = "black", leavesshape = "egg", leavesfillcolor = "gray",
  leavesfontcolor = "black", leavesfontname = "helvetica")
}
\arguments{
\item{...}{One or more character vectors containing a single level of nodes. The character vector containing the end nodes should not be entered here. 
If there isn't a node for a level of the branch, it should be entered as ""}

\item{leaves}{Character vector of values containing the last node of the branches}

\item{weights}{Character or numeric vector of weights associated with the end node of the branches (Optional)}

\item{nodestyle}{Style of the nodes, default is filled, rounded}

\item{nodeshape}{Shape of the nodes, default is box}

\item{nodefillcolor}{Fill color of the nodes, default is white}

\item{nodefontname}{Font of the nodes, default is helvetica}

\item{nodefontcolor}{Font color of the nodes, default is black}

\item{leavesshape}{Shape of the leaves, default is egg}

\item{leavesfillcolor}{Fill color of the leaves, default is gray}

\item{leavesfontcolor}{Font color of the leaves, default is black}

\item{leavesfontname}{Font of the leaves, default is helvetica}
}
\value{
Value hierarchy tree plot
}
\description{
: Plots a value hierarchy tree
}
\examples{
branches<- as.data.frame(matrix(ncol=5,nrow=7))
names(branches)<-c("Level1","Level2","Level3","leaves","weights")
branches[1,]<-rbind("QB","Elusiveness","Speed","Forty","0.092")
branches[2,]<-rbind("QB","Elusiveness","Agility","Shuttle","0.138")
branches[3,]<-rbind("QB","Size","","Height","0.096")
branches[4,]<-rbind("QB","Size","","Weight","0.224")
branches[5,]<-rbind("QB","Intelligence","","Wonderlic","0.07")
branches[6,]<-rbind("QB","Strength","Explosiveness","Vertical","0.152")
branches[7,]<-rbind("QB","Strength","Power","Broad","0.228")

value_hierarchy_tree(branches$Level1,branches$Level2,branches$Level3,
leaves=branches$leaves,weights=branches$weights)

}