% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{inDatabaseSchema}
\alias{inDatabaseSchema}
\title{Refer to a table in a database schema}
\usage{
inDatabaseSchema(databaseSchema, table)
}
\arguments{
\item{databaseSchema}{The name of the database schema. See details for platform-specific details.}

\item{table}{The name of the table in the database schema.}
}
\value{
An object representing the table and database schema.
}
\description{
Can be used with \code{\link[dplyr:tbl]{dplyr::tbl()}} to indicate a table in a specific database schema.
}
\details{
The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. Impala: the databaseSchema should specify the database. Oracle:
The databaseSchema should specify the Oracle 'user'. All other : The databaseSchema should
specify the schema.
}
