% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\docType{methods}
\name{dbQuoteIdentifier,DatabaseConnectorConnection,character-method}
\alias{dbQuoteIdentifier,DatabaseConnectorConnection,character-method}
\title{Quote identifiers}
\usage{
\S4method{dbQuoteIdentifier}{DatabaseConnectorConnection,character}(conn,
  x, ...)
}
\arguments{
\item{conn}{A subclass of \linkS4class{DBIConnection}, representing
an active connection to an DBMS.}

\item{x}{A character vector, \link{SQL} or \link{Id} object to quote as identifier.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbQuoteIdentifier()} returns an object that can be coerced to \link{character},
of the same length as the input.
For an empty character vector this function returns a length-0 object.
The names of the input argument are preserved in the output.
When passing the returned object again to \code{dbQuoteIdentifier()}
as \code{x}
argument, it is returned unchanged.
Passing objects of class \link{SQL} should also return them unchanged.
(For backends it may be most convenient to return \link{SQL} objects
to achieve this behavior, but this is not required.)

An error is raised if the input contains \code{NA},
but not for an empty string.
}
\description{
Call this method to generate a string that is suitable for
use in a query as a column or table name, to make sure that you
generate valid SQL and protect against SQL injection attacks. The inverse
operation is \code{\link[=dbUnquoteIdentifier]{dbUnquoteIdentifier()}}.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbQuoteIdentifier")}
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbColumnInfo}}, \code{\link{dbFetch}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsReadOnly}},
  \code{\link{dbIsValid}}, \code{\link{dbQuoteLiteral}},
  \code{\link{dbQuoteString}},
  \code{\link{dbUnquoteIdentifier}}
}
