% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\docType{methods}
\name{dbQuoteString,DatabaseConnectorConnection,character-method}
\alias{dbQuoteString,DatabaseConnectorConnection,character-method}
\title{Quote literal strings}
\usage{
\S4method{dbQuoteString}{DatabaseConnectorConnection,character}(conn, x, ...)
}
\arguments{
\item{conn}{A subclass of \linkS4class{DBIConnection}, representing
an active connection to an DBMS.}

\item{x}{A character vector to quote as string.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbQuoteString()} returns an object that can be coerced to \link{character},
of the same length as the input.
For an empty character vector this function returns a length-0 object.

When passing the returned object again to \code{dbQuoteString()}
as \code{x}
argument, it is returned unchanged.
Passing objects of class \link{SQL} should also return them unchanged.
(For backends it may be most convenient to return \link{SQL} objects
to achieve this behavior, but this is not required.)
}
\description{
Call this method to generate a string that is suitable for
use in a query as a string literal, to make sure that you
generate valid SQL and protect against SQL injection attacks.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbQuoteString")}
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbColumnInfo}}, \code{\link{dbFetch}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsReadOnly}},
  \code{\link{dbIsValid}}, \code{\link{dbQuoteIdentifier}},
  \code{\link{dbQuoteLiteral}},
  \code{\link{dbUnquoteIdentifier}}
}
