% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSpaceMab.R
\docType{class}
\name{DataSpaceMab}
\alias{DataSpaceMab}
\title{The DataSpaceMab class}
\usage{
DataSpaceMab
}
\value{
an instance of \code{DataSpaceMab}
}
\description{
The DataSpaceMab class
}
\section{Constructor}{

\code{DataSpaceConnection$getMab()}
}

\section{Fields}{

\describe{
  \item{\code{config}}{
    A list. Stores configuration of the connection object such as
    URL, path and username.
  }
  \item{\code{studyAndMabs}}{
    A data.table. The table of available mAbs by study.
  }
  \item{\code{mabs}}{
    A data.table. The table of available mAbs and their attributes.
  }
  \item{\code{nabMab}}{
    A data.table. The table of mAbs and their neutralizing measurements
    against viruses.
  }
  \item{\code{studies}}{
    A data.table. The table of available studies.
  }
  \item{\code{assays}}{
    A data.table. The table of assay status by study.
  }
  \item{\code{variableDefinitions}}{
    A data.table. The table of variable definitions.
  }
}
}

\section{Methods}{

\describe{
  \item{\code{initialize(mabMixture, filters, config)}}{
    Initialize \code{DataSpaceMab} object.
    See \code{\link{DataSpaceConnection}}.
  }
  \item{\code{print()}}{
    Print \code{DataSpaceMab} object summary.
  }
  \item{\code{refresh()}}{
    Refresh the mab object to update datasets.
  }
}
}

\examples{
\dontrun{
# Create a connection (Initiate a DataSpaceConnection object)
con <- connectDS()

# Browse the mAb Grid
con$mabGridSummary

# Filter the grid by viruses
con$filterMabGrid(using = "virus", value = c("242-14", "Q23.17", "6535.3", "BaL.26", "DJ263.8"))

# Filter the grid by donor species (llama)
con$filterMabGrid(using = "donor_species", value = "llama")

# Check the updated grid
con$mabGridSummary

# Retrieve available viruses in the filtered grid
con$mabGrid[, unique(virus)]

# Retrieve available clades for 1H9 mAb mixture in the filtered grid
con$mabGrid[mab_mixture == "1H9", unique(clade)]

# Create a DataSpaceMab object that contains the filtered mAb data
mab <- con$getMab()
mab

# Inspect the `nabMab` field
mab$nabMab
}

}
\seealso{
\code{\link{connectDS}} \code{\link{DataSpaceConnection}}
}
\keyword{datasets}
