% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatables.R
\name{tableHeader}
\alias{tableHeader}
\alias{tableFooter}
\title{Generate a table header or footer from column names}
\usage{
tableHeader(names, escape = TRUE)

tableFooter(names, escape = TRUE)
}
\arguments{
\item{names}{a character vector of the column names of the table (if it is an
object with column names, its column names will be used instead)}

\item{escape}{whether to escape the names (see \code{\link{datatable}})}
}
\value{
A tag object generated by \code{htmltools::tags}.
}
\description{
Convenience functions to generate a table header (\samp{<thead></thead>}) or
footer (\samp{<tfoot></tfoot>}) given the column names. They are basically
wrappers of \code{htmltools::tags$th} applied to the column names.
}
\examples{
library(DT)
tableHeader(iris)  # or equivalently,
tableHeader(colnames(iris))
tableFooter(iris)  # footer

library(htmltools)
tags$table(tableHeader(iris), tableFooter(iris))
}
