% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempGP.R
\name{updateData.tempGP}
\alias{updateData.tempGP}
\title{Update the data in a tempGP object}
\usage{
\method{updateData}{tempGP}(
  object,
  newX,
  newY,
  newT = NULL,
  replace = TRUE,
  updateModelF = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class tempGP.}

\item{newX}{A matrix with each column corresponding to one input variable.}

\item{newY}{A vector with each element corresponding to the output at the corresponding row of \code{newX}.}

\item{newT}{A vector with time indices of the new datapoints. If \code{NULL}, the function assigns natural numbers starting with one larger than the existing time indices in \code{trainT}.}

\item{replace}{A boolean to specify whether to replace the old data with the new one, or to add the new data while still keeping all the old data. Default is TRUE, which replaces the top \code{m} rows from the old data, where \code{m} is the number of data points in the new data.}

\item{updateModelF}{A boolean to specify whether to update \code{modelF} as well. If the original \code{tempGP} model is trained on a sufficiently large dataset (say one year), updating \code{modelF} regularly may not result in any significant improvement, but can be computationally expensive.}

\item{...}{additional arguments for future development}
}
\value{
An updated object of class \code{tempGP}.
}
\description{
This function updates \code{trainX}, \code{trainY}, and \code{trainT} in a \code{tempGP} object. By default, if the new data has \code{m} data points, the function removes top \code{m} data points from the tempGP object and appends the new data at the bottom, thus keeping the total number of data points the same. This can be overwritten by setting \code{replace = FALSE} to keep all the data points (old and new). The method also updates \code{modelG} by computing and updating residuals at the new data points. \code{modelF} can be also be updated by setting the argument \code{updateModelF} to \code{TRUE}, though not required generally (see comments in the \code{Arguments}.)
}
\examples{
   data = DSWE::data1
   trainindex = 1:100 #using the first 100 data points to train the model
   traindata = data[trainindex,]
   xCol = 2 #input variable columns
   yCol = 7 #response column
   trainX = as.matrix(traindata[,xCol])
   trainY = as.numeric(traindata[,yCol])
   tempGPObject = tempGP(trainX, trainY)
   newdata = DSWE::data1[101:110,] # defining new data  
   newX = as.matrix(newdata[,xCol, drop = FALSE])
   newY = as.numeric(newdata[,yCol])
   tempGPupdated = updateData(tempGPObject, newX, newY)
}
