% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSObject.R
\docType{class}
\name{DSObject-class}
\alias{DSObject-class}
\title{DSObject class}
\description{
Base class for all other DataSHIELD classes (e.g., drivers, connections). This
is a virtual Class: No objects may be created from it.
}
\details{
More generally, DataSHIELD defines a very small set of classes and generics that
allows users and applications perform meta-analysis with a common interface.  The
virtual classes are `DSDriver` that individual drivers extend,
`DSConnection` that represent instances of DataSHIELD-aware data repository connections, and
`DSResult` that represent the result of a DataSHIELD operation. These three
classes extend the basic class of `DSObject`, which serves as the root
or parent of the class hierarchy.
}
\section{Implementation notes}{

An implementation MUST provide methods for the following generics:

\itemize{
  \item \code{\link{dsGetInfo}}
}

It MAY also provide methods for:

\itemize{
  \item \code{\link{summary}} Print a concise description of the
    object. The default method invokes `dsGetInfo(dsObj)` and prints
    the name-value pairs one per line. Individual implementations may
    tailor this appropriately.
}
}

\examples{
\dontrun{
drv <- DSOpal::Opal()
con <- dsConnect(drv, "username", "password", "https://opal.example.org")

rs <- dsAssign(con, "Project.TableA")
is(drv, "DSObject")  ## True
is(con, "DSObject")  ## True
is(rs, "DSObject")   ## True

dsDisconnect(con)
}
}
\seealso{
Other DS classes: 
\code{\link{DSConnection-class}},
\code{\link{DSDriver-class}},
\code{\link{DSResult-class}}
}
\concept{DS classes}
