% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_basicbacteria_discrete.R
\name{simulate_basicbacteria_discrete}
\alias{simulate_basicbacteria_discrete}
\title{Simulation of a basic model with bacteria and an immune response
illustrating a simple within-host predator-prey model}
\usage{
simulate_basicbacteria_discrete(B0 = 10, I0 = 1, tmax = 30, g = 1,
  Bmax = 1e+06, dB = 0.1, k = 1e-07, r = 0.001, dI = 1,
  dt = 0.01)
}
\arguments{
\item{B0}{initial number of bacteria}

\item{I0}{initial number/strength of immune response}

\item{tmax}{Maximum simulation time, units depend on choice of units for your
parameters.}

\item{g}{rate of bacteria growth}

\item{Bmax}{carrying capacity for bacteria}

\item{dB}{death rate of bacteria}

\item{k}{rate at which bacteria are killed by immune response}

\item{r}{rate at which immune response is induced by bacteria}

\item{dI}{death rate of immune response}

\item{dt}{Time step for simulation, units depend on choice of units for your
parameters.}
}
\value{
The function returns the output as a list.
The time-series from the simulation is returned as element ts
in the list,
the 1st column of ts is Time, the rest are the
bacteria and immune response variables, which are labeled Bd and Id
to indicate discrete model.
}
\description{
This function runs a simulation of a basic 2 compartment model
using discrete time steps.
The user provides initial conditions and parameter values for the system.
The function simulates the model by advancing from start to end time in discrete time steps.
The function returns a matrix containing time-series of each variable and time.
}
\details{
A simple 2 compartment model is simulated as a discrete time model.
}
\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter values
  or fractions > 1), the code will likely abort with an error message
}

\examples{
# To run the simulation with default parameters just call the function:
result <- simulate_basicbacteria_discrete()
# To choose parameter values other than the standard one, specify them like such:
result <- simulate_basicbacteria_discrete(B0 = 100, I0 = 10, tmax = 100, g = 0.5)
# You should then use the simulation result returned from the function, like this:
plot(result$ts[,'Time'],result$ts[,'Bd'])
}
\seealso{
See the Shiny app documentation that uses this simulator
function for more details on this model.
}
\author{
Andreas Handel
}
