% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_idcontrol.R
\name{simulate_idcontrol}
\alias{simulate_idcontrol}
\title{Simulation of a compartmental infectious disease transmission model including different control mechanisms}
\usage{
simulate_idcontrol(S0 = 1000, I0 = 1, E0 = 0, Sv0 = 1000, Iv0 = 0,
  tmax = 300, bP = 0, bA = 0, bI = 1/1000, bE = 0, bv = 1/1000,
  bh = 1/1000, gP = 0.5, gA = 0.5, gI = 0.5, pA = 1, pI = 10,
  c = 1, f = 0, d = 0, w = 0, birthh = 0, deathh = 0, birthv = 0,
  deathv = 0)
}
\arguments{
\item{S0}{initial number of susceptible hosts}

\item{I0}{initial number of infected and symptomatic hosts}

\item{E0}{initial amount of pathogen in environment}

\item{Sv0}{initial number of susceptible vectors}

\item{Iv0}{initial number of infected vectors}

\item{tmax}{maximum simulation time, in units of months}

\item{bP}{rate of transmission from pre-symptomatic to susceptible hosts}

\item{bA}{rate of transmission from asymptomatic to susceptible hosts}

\item{bI}{rate of transmission from symptomatic to susceptible hosts}

\item{bE}{rate of transmission from environment to susceptible hosts}

\item{bv}{rate of transmission from infected vectors to susceptible hosts}

\item{bh}{rate of transmission from symptomatic hosts to susceptible vectors}

\item{gP}{rate at which a person leaves the P compartment}

\item{gA}{rate at which a person leaves the A compartment}

\item{gI}{rate at which a person leaves the I compartment}

\item{pA}{rate of pathogen shedding into environment by asymptomatic hosts}

\item{pI}{rate of pathogen shedding into environment by symptomatic hosts}

\item{c}{rate of pathogen decay in environment}

\item{f}{fraction of pre-symptomatic individuals that have an asymptomatic infection}

\item{d}{fraction of symptomatic infected hosts that die due to disease}

\item{w}{rate at which recovered persons loose immunity and return to susceptible state}

\item{birthh}{the rate at which new hosts enter the model (are born)}

\item{deathh}{the rate of natural death of hosts (the inverse it the average lifespan)}

\item{birthv}{the rate at which new vectors enter the model (are born)}

\item{deathv}{the rate of natural death of vectors (the inverse it the average lifespan)}
}
\value{
This function returns the simulation result as obtained from a call
  to the deSolve ode solver
}
\description{
Simulation of a compartmental model with several different compartments:
  Susceptibles (S), Infected and Pre-symptomatic (P),
  Infected and Asymptomatic (A), Infected and Symptomatic (I),
  Recovered and Immune (R) and Dead (D).
  Also modeled is an environmental pathogen stage (E), and susceptible (Sv) and infected (Iv) vectors.

  Any initial conditions not specified below start at 0.
}
\details{
A compartmental ID model with several states/compartments
  is simulated as a set of ordinary differential
  equations. The function returns the output from the odesolver as a matrix,
  with one column per compartment/variable. The first column is time.
}
\section{Warning}{

  This function does not perform any error checking. So if you try to do
  something nonsensical (e.g. have I0 > PopSize or any negative values or fractions > 1),
  the code will likely abort with an error message
}

\examples{
  # To run the simulation with default parameters just call this function
  result <- simulate_idcontrol()
  # To choose parameter values other than the standard one, specify them e.g. like such
  result <- simulate_idcontrol(S0 = 2000, I0 = 10, tmax = 100, f = 0.1, d = 0.2)
  # You should then use the simulation result returned from the function, e.g. like this:
  plot(result[,1],result[,2],xlab='Time',ylab='Number Susceptible',type='l')
}
\references{
See e.g. Keeling and Rohani 2008 for SIR models and the
  documentation for the deSolve package for details on ODE solvers
}
\seealso{
The UI of the shiny app 'IDPatterns', which is part of this package, contains more details on the model
}
\author{
Andreas Handel
}
