% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DE2SubPath.R
\name{DE2SubPath}
\alias{DE2SubPath}
\title{Calculating eigenvector centrality of subpathways}
\usage{
DE2SubPath(inexpData,Label,Subpathway,Go,Jaccard,Go_SubPath_gene,perm=FALSE,nperm=1000)
}
\arguments{
\item{inexpData}{A gene expression profile of interest (rows are genes, columns are samples).The data in the expression profile is best not be log2 converted.}

\item{Label}{A character vector consist of "0" and "1" which represent sample class in gene expression profile. "0" means normal sample and "1" means disease sample.}

\item{Subpathway}{Subpathway information from SubpathwayMiner.}

\item{Go}{Biological Process data from Gene Ontology.}

\item{Jaccard}{Jaccard score shared by a subpathway with Biological Process.}

\item{Go_SubPath_gene}{Genes symble shared by a subpathway with Biological Process.}

\item{perm}{A boolean value. If perm=TRUE, the permutations will be implemented.}

\item{nperm}{Number of random permutations (default: 1000).}
}
\value{
A dataframe with seven columns those are subpath ID, subpath name, subpath size, genes in subpath, centralscore (eigenvector centrality), Pvalue and FDR.
}
\description{
The function "DE2SubPath" is used to calculate the eigenvector centrality of subpathways.
According to our method, in this function, the user needs to input 6 variables. All six variables can obtain from our example data, those data from KEGG and GO, and the user can also change at will.
}
\examples{
library(igraph)
#Obtain input data
GEP<-GetExample('GEP')
label<-GetExample('label')
SubPathwayInfo<-GetExample('SubPathwayInfo')
GoInfo<-GetExample('GoInfo')
Jaccardscore<-GetExample('Jaccardscore')
GoSubPconGene<-GetExample('GoSubPconGene')
#Run the function
\donttest{DE2SubPathresult<-DE2SubPath(inexpData=GEP,Label=label,Subpathway=SubPathwayInfo,
                      Go=GoInfo,Jaccard=Jaccardscore,Go_SubPath_gene=GoSubPconGene,
                      perm=FALSE)

DE2SubPathresult_P<-DE2SubPath(inexpData=GEP,Label=label,Subpathway=SubPathwayInfo,
                      Go=GoInfo,Jaccard=Jaccardscore,Go_SubPath_gene=GoSubPconGene,
                      perm=TRUE)}
}
