% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcFit.R
\name{dmcFitAgg}
\alias{dmcFitAgg}
\title{dmcFitAgg}
\usage{
dmcFitAgg(
  resOb,
  nTrl = 1e+05,
  startVals = list(),
  minVals = list(),
  maxVals = list(),
  fixedFit = list(),
  fitInitialGrid = TRUE,
  fitInitialGridN = 10,
  fixedGrid = list(),
  nCAF = 5,
  nDelta = 19,
  pDelta = vector(),
  printInputArgs = TRUE,
  printResults = FALSE
)
}
\arguments{
\item{resOb}{Observed data (see flankerData and simonTask for data format)}

\item{nTrl}{Number of trials to use within dmcSim.}

\item{startVals}{Starting values for to-be estimated parameters. This is a list with values specified individually for
amp, tau, mu, bnds, resMean, resSD, aaShape, spShape, sigm (e.g., startVals = list(amp = 20, tau = 200, mu = 0.5, bnds = 75, resMean = 300,
resSD = 30, aaShape = 2, spShape = 3, sigm = 4)).}

\item{minVals}{Minimum values for the to-be estimated parameters. This is a list with values specified individually for
amp, tau, mu, bnds, resMean, resSD, aaShape, spShape, sigm (e.g., minVals = list(amp = 10, tau = 5, mu = 0.1, bnds = 20, resMean = 200,
resSD = 5, aaShape = 1, spShape = 2, sigm = 1)).}

\item{maxVals}{Maximum values for the to-be estimated parameters. This is a list with values specified individually for
amp, tau, mu, bnds, resMean, resSD, aaShape, spShape, sigm (e.g., maxVals = list(amp = 40, tau = 300, mu = 1.0, bnds = 150, resMean = 800,
resSD = 100, aaShape = 3, spShape = 4, sigm = 10))}

\item{fixedFit}{Fix parameter to starting value. This is a list with bool values specified individually for
amp, tau, mu, bnds, resMean, resSD, aaShape, spShape, sigm (e.g., fixedFit = list(amp = F,  tau = F, mu = F, bnds = F, resMean = F,
resSD = F, aaShape = F, spShape = F, sigm = T))}

\item{fitInitialGrid}{TRUE/FALSE}

\item{fitInitialGridN}{10 reduce if searching more than 1 initial parameter}

\item{fixedGrid}{Fix parameter for initial grid search.  This is a list with bool values specified individually for
amp, tau, mu, bnds, resMean, resSD, aaShape, spShape, sigm (e.g., fixedGrid = list(amp = T, tau = F, mu = T, bnds = T, resMean = T,
resSD = T, aaShape = T, spShape = T, sigm = T))}

\item{nCAF}{Number of CAF bins.}

\item{nDelta}{Number of delta bins.}

\item{pDelta}{Alternative to nDelta by directly specifying required percentile values}

\item{printInputArgs}{TRUE/FALSE}

\item{printResults}{TRUE/FALSE}
}
\value{
dmcfit

The function returns a list with the relevant results from the fitting procedure. The list
is accessed with obj$name with the the following:
\item{obj$means}{Condition means for reaction time and error rate}
\item{obj$caf}{Accuracy per bin for compatible and incompatible trials}
\item{obj$delta}{Mean RT and compatibility effect per bin}
\item{obj$sim}{Individual trial data points (reaction times/error) and activation vectors from simulation}
\item{obj$par}{The fitted model parameters + final RMSE of the fit}
}
\description{
Fit theoretical data generated from dmcSim to observed data by
minimizing the root-mean-square error (RMSE) between a weighted combination
of the CAF and CDF functions.
}
\examples{
\donttest{
# Example 1: Flanker data from Ulrich et al. (2015)
fit <- dmcFitAgg(flankerData)  # only initial search tau
plot(fit, flankerData)
summary(fit)

# Example 2: Simon data from Ulrich et al. (2015)
fit <- dmcFitAgg(simonData)    # only initial search tau
plot(fit, simonData)
summary(fit)

# Example 3: Flanker data from Ulrich et al. (2015) with non-default
# start vals and some fixed values
fit <- dmcFitAgg(flankerData,
                 startVals = list(mu = 0.6, aaShape = 2.5),
                 fixedFit = list(mu = TRUE, aaShape = TRUE))

# Example 4: Simulated Data (+ve going delta function)
dat <- createDF(nVP = 20, nTrl = 500, design = list("Comp" = c("comp", "incomp")))
dat <- addDataDF(dat,
                 RT = list("Comp_comp"   = c(510, 100, 100),
                           "Comp_incomp" = c(540, 130, 85)),
                 Error = list("Comp_comp"   = c(4, 3, 2, 1, 1),
                              "Comp_incomp" = c(20, 4, 3, 1, 1)))
datOb <- dmcObservedData(dat, columns = c("VP", "Comp", "RT", "Error"))
plot(datOb)
fit <- dmcFitAgg(datOb, nTrl = 5000)
plot(fit, datOb)
summary(fit)
}

}
