% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_connection.R
\name{db_connection}
\alias{db_connection}
\title{db_connection helper function}
\usage{
db_connection(
  system_name = NULL,
  db_type,
  headless = FALSE,
  from_env = TRUE,
  settings = NULL,
  timeout = 30,
  logfile_dir = NULL,
  lib_path = NULL
)
}
\arguments{
\item{system_name}{(Default = NULL) A character. Name of the database system.
Used to find the correct settings from the env. If you don't want to
load the settings from the environment, use the `settings` parameter.
Otherwise this funcion will search for all settings beginning with
`system_name` in the environment. If `system_name = "i2b2"` settings like
`I2B2_HOST` or `I2B2_PORT` (notice the uppercase) will be loaded from
the environment. You can load such an env file e.g. by using
`DIZutils::set_env_vars(path_to_file)`.}

\item{db_type}{A character. Type of the database system. Currently
implemented systems are: 'postgres', 'oracle'.}

\item{headless}{A boolean (default: `FALSE`). Indicating, if the function is
run only in the console (`headless = TRUE`) or on a GUI frontend
(`headless = FALSE`).}

\item{from_env}{A boolean (default: `TRUE`). Should database connection
be read from the environment or from a settings file. All necessary
parameters must be uppercase and have the prefix of the db_name. E.g.:
`I2B2_HOST` or `I2B2_PORT`. See the `settings` parameter for all
necessary variables.}

\item{settings}{A list. Required if `from_env == FALSE`. A list containing
settings for the database connection. Required fields are `host`,
`db_name`, `port`, `user` and `password`.
Additionally for Oracle DB's: `sid` (instead of `db_name`).
If `settings` is set, `from_env` will be set to `FALSE` automatically.}

\item{timeout}{A timeout in sec. for the db-connection establishment.
Values below 2 seconds are not recommended.
Default is 30 seconds.}

\item{logfile_dir}{(Optional, String, default: "tempdir()")
The absolute path to folder where the logfile will be stored.}

\item{lib_path}{A character string. The path to the ojdbc*.jar file.
If you run one of the R-containers from the UK-Erlangen DIZ, there
might be a lib for oracle here: `lib_path = "/opt/libs/ojdbc8.jar"`}
}
\value{
If successful, the result will be the established connection.
  Otherwise the result will be null.
}
\description{
Internal function to test and get the database connection of
  the target data system.
}
\examples{
\dontrun{
db_con <- DIZutils::db_connection(
  db_name = "i2b2",
  db_type = "postgres",
  headless = TRUE,
  logfile_dir = tempdir()
)}

}
\seealso{
{
\code{\link[DBI]{dbConnect}}, \code{\link[RPostgres]{RPostgres}}
}
}
