% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dCorAvg.R
\name{dCorAvg}
\alias{dCorAvg}
\title{Get average empirical differential correlations.}
\usage{
dCorAvg(zDiff, zDiffPerm, dCorAvgType, oneSidedPVal = FALSE,
  secondMat = FALSE, dCorAvgMethod = "median")
}
\arguments{
\item{zDiff}{Matrix containing the actual difference of z-scores for each gene-gene pair.}

\item{zDiffPerm}{Matrix containing the differences of z-scores for each gene-gene pair in simulated data.}

\item{dCorAvgType}{Character vector specifying the type of average differential correlation calculation that should be performed. Types = c("gene_average", "total_average"). gene_average calculates whether each genes' differential correlation with all others is more than expected via permutation samples (and subsequent empirical FDR adjustment, in the case of > 1 gene), while total_average calculates whether the total average differential correlation is higher than expected via permutation samples. If splitSet is specified, then only genes in the splitSet have their average gene differential correlation calculated if gene_average is chosen.}

\item{oneSidedPVal}{If the dCorAvgType test is total_average, this option specifies whether a one-sided p-value should be reported, as opposed to a two-sided p-value. That is, if the average difference of z-scores is greater than zero, test whether the permutation average difference of z-scores are less than that average to get the p-value, and vice versa for the case that the average difference of z-scores is less than 0. Otherwise, test whether the absolute value of the average difference in z-scores is greater than the absolute values of the permutation average difference in z-scores. Default = FALSE.}

\item{secondMat}{Logical indicator of whether there is a second matrix in the comparison or not.}

\item{dCorAvgMethod}{Character vector specifying the method for calculating the "average" differential correlation calculation that should be used. Options = "median", "mean".}
}
\value{
A list containing the average difference(s) in z-score and the empirical p-value of that statistic calculated using the permutation samples.
}
\description{
Finds the average (median or mean) of differential correlations for either one gene versus all others or for all gene pairs in the input matrix of differences in z-scores between conditions, with significance calculated via a comparison with the permutation samples.
}

