% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEploidR.R
\name{plotAltVsRef}
\alias{plotAltVsRef}
\title{Plot coverage}
\usage{
plotAltVsRef(ref, alt, title = "Alt vs Ref", exclude.ref = c(),
  exclude.alt = c())
}
\arguments{
\item{ref}{Numeric array of reference allele count.}

\item{alt}{Numeric array of alternative allele count.}

\item{title}{Figure title, "Alt vs Ref" by default}

\item{exclude.ref}{Numeric array of reference allele count at sites that are not deconvoluted.}

\item{exclude.alt}{Numeric array of alternative allele count at sites that are not deconvoluted}
}
\description{
Plot alternative allele count vs reference allele count at each site.
}
\examples{
# Example 1
refFile = system.file("extdata", "PG0390-C.test.ref", package = "DEploid")
altFile = system.file("extdata", "PG0390-C.test.alt", package = "DEploid")
PG0390CoverageTxt = extractCoverageFromTxt(refFile, altFile)
plotAltVsRef( PG0390CoverageTxt$refCount, PG0390CoverageTxt$altCount )

# Example 2
vcfFile = system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390CoverageVcf = extractCoverageFromVcf(vcfFile)
plotAltVsRef( PG0390CoverageVcf$refCount, PG0390CoverageVcf$altCount )

}

