% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dyn-methods.R
\docType{class}
\name{DeponsDyn-class}
\alias{DeponsDyn-class}
\title{DeponsDyn-class}
\description{
Stores objects containing population dynamics output and energetic
output simulated using the DEPONS model.
}
\details{
The following columns are included in the simulation output data
frame: 'tick', which indicates the number of half-hourly time steps since the
start of the simulation; 'count', which indicates the population size at a
given time; 'anim.e', showing the average amount of energy stored by simulated
animals; 'lands.e', which shows the total amount of energy in the landscape,
and 'real.time' which shows the time relative to 'startday'.
}
\section{Slots}{

\describe{
\item{\code{title}}{Character. Name of the object or simulation}

\item{\code{landscape}}{Character. Identifier for the landscape used in the DEPONS
simulations. The landscapes 'DanTysk', 'Gemini', 'Kattegat', 'North Sea',
'Homogeneous', and 'User defined' are distributed with the DEPONS model.}

\item{\code{simtime}}{\code{\link{POSIXlt}} object with the date and time when the
simulation was finished. This is read from the name of the imput file.}

\item{\code{startday}}{POSIXlt object with the first day of the simulation, i.e.
the first day in the period that the simulations are intended to represent in
the real world.}

\item{\code{dyn}}{Data frame with simulation output.}
}}

\note{
DeponsDyn-objects are usually read in from csv files produced during
DEPONS simulations. These files are named 'Statistics.XXX.csv', where XXX
indicates the date and time when the simulation was finished.
}
\examples{
a.DeponsDyn <- new("DeponsDyn")
a.DeponsDyn
}
\seealso{
\code{\link[DEPONS2R]{plot.DeponsDyn}} and
\code{\link[DEPONS2R]{read.DeponsDyn}}.
}
