% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LM_SFARIMAEstimation.R
\name{sfarima.est}
\alias{sfarima.est}
\title{Estimation of a SFARIMA-process}
\usage{
sfarima.est(Y, model_order = list(ar = c(1, 1), ma = c(1, 1)))
}
\arguments{
\item{Y}{A numeric matrix that contains the demeaned observations of the
random field or functional time-series.}

\item{model_order}{A list containing the orders of the SFARIMA model in the
form \code{model_order = list(ar = c(p1, p2), ma = c(q1, q2))}. Default
value is a \eqn{SFARIMA((1, 1), (1, 1), d)} model.}
}
\value{
The function returns an object of class \code{"sfarima"} including
 \tabular{ll}{
  \code{Y} \tab The matrix of observations, inherited from input.\cr
  \code{innov} The estimated innovations.\cr
  \code{model} \tab The estimated model consisting of the coefficient 
  matrices \code{ar} and \code{ma}, the estimated long memory parameters
  \code{d} and standard deviation of innovations \code{sigma}.\cr
  \code{stnry} \tab An logical variable indicating whether the estimated
  model is stationary.\cr
}
}
\description{
Parametric Estimation of a \eqn{SFARIMA(p, q, d)}-process on a 
 lattice.
}
\section{Details}{

The MA- and AR-parameters as well as the long-memory parameters \deqn{d} of a
SFARIMA process are estimated by minimization of the residual sum of squares
RSS. Lag-orders of \eqn{SFARIMA(p, q, d)} are given by \eqn{p = (p_1, p_2), 
q = (q_1, q_2)}{p = (p1, p2), q = (q1, q2)}, where \eqn{p_1, q_1}{p1, q1} are
the lags over the rows and \eqn{p_2, q_2}{p2, q2} are the lags over the 
columns. The estimated process is based on the (separable) model 
\deqn{\varepsilon_{ij} = \Psi_1(B) \Psi_2(B) \eta_{ij}}, where \deqn{\Psi_i =
(1 - B_i)^{-d_i}\phi^{-1}_i(B_i)\psi_i(B_i), i = 1,2}.
}

\examples{
# See vignette("DCSmooth") for examples and explanation

## simulation of SFARIMA process
ma <- matrix(c(1, 0.2, 0.4, 0.1), nrow = 2, ncol = 2)
ar <- matrix(c(1, 0.5, -0.1, 0.1), nrow = 2, ncol = 2)
d <- c(0.1, 0.1)
sigma <- 0.5
sfarima_model <- list(ar = ar, ma = ma, d = d, sigma = sigma)
sfarima_sim <- sfarima.sim(50, 50, model = sfarima_model)

## estimation of SFARIMA process
sfarima.est(sfarima_sim$Y)$model
sfarima.est(sfarima_sim$Y, 
           model_order = list(ar = c(1, 1), ma = c(0, 0)))$model

}
\seealso{
\code{\link{sarma.est}, \link{sfarima.sim}}
}
