% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcem_heap.R
\name{remove_node}
\alias{remove_node}
\title{remove_node: Part of DCEM package.}
\usage{
remove_node(heap, node_key, index)
}
\arguments{
\item{heap}{(dataframe): The dataframe holding the heap structure.}

\item{node_key}{(numeric): The key corresponding to the node to be removed.}

\item{index}{(numeric): The index of the node to be removed.}
}
\value{
data frame: The heap with node removed.
}
\description{
Removes the given node from the heap structure. This function is for internal use and is called
by the \code{\link{dcem_star_cluster_uv}} (univariate data) and
\code{\link{dcem_star_cluster_mv}} (multivariate data).
}
\examples{
# Create a sample data frame
heap <- data.frame(keys=c(0,3,4), vals=c(7,7,4))

# Build the heap from the data frame.
heap <- build_heap(heap)

# Remove a node from the heap (key=3).
remove_node(heap, 3, 2)

}
\references{
Using data to build a better EM: EM* for big data.

Hasan Kurban, Mark Jenne, Mehmet M. Dalkilic
(2016) <doi:https://doi.org/10.1007/s41060-017-0062-1>.
}
\author{
Parichit Sharma \email{parishar@iu.edu}, Hasan Kurban, Mark Jenne, Mehmet Dalkilic
This work is partially supported by NCI Grant 1R01CA213466-01.
}
