% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-sql-quote-string.R
\docType{data}
\name{spec_sql_quote_string}
\alias{spec_sql_quote_string}
\title{spec_sql_quote_string}
\value{
\code{dbQuoteString()} returns an object that can be coerced to \link{character},
of the same length as the input.
For an empty character vector this function returns a length-0 object.

When passing the returned object again to \code{dbQuoteString()}
as \code{x}
argument, it is returned unchanged.
Passing objects of class \link{SQL} should also return them unchanged.
(For backends it may be most convenient to return \link{SQL} objects
to achieve this behavior, but this is not required.)
}
\description{
spec_sql_quote_string
}
\section{Specification}{

The returned expression can be used in a \code{SELECT ...} query,
and for any scalar character \code{x} the value of
\code{dbGetQuery(paste0("SELECT ", dbQuoteString(x)))[[1]]}
must be identical to \code{x},
even if \code{x} contains
spaces,
tabs,
quotes (single
or double),
backticks,
or newlines
(in any combination)
or is itself the result of a \code{dbQuoteString()} call coerced back to
character (even repeatedly).
If \code{x} is \code{NA}, the result must merely satisfy \code{\link[=is.na]{is.na()}}.
The strings \code{"NA"} or \code{"NULL"} are not treated specially.

\code{NA} should be translated to an unquoted SQL \code{NULL},
so that the query \code{SELECT * FROM (SELECT 1) a WHERE ... IS NULL}
returns one row.
}

