% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBConnection.R
\name{dbExecute}
\alias{dbExecute}
\title{Execute an update statement, query number of rows affected, and then close result set}
\usage{
dbExecute(conn, statement, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{statement}{a character string containing SQL.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbExecute()} always returns a
scalar
numeric
that specifies the number of rows affected
by the statement.
An error is raised when issuing a statement over a closed
or invalid connection,
if the syntax of the statement is invalid,
or if the statement is not a non-\code{NA} string.
}
\description{
Executes a statement and returns the number of rows affected.
\code{dbExecute()} comes with a default implementation
(which should work with most backends) that calls
\code{\link[=dbSendStatement]{dbSendStatement()}}, then \code{\link[=dbGetRowsAffected]{dbGetRowsAffected()}}, ensuring that
the result is always free-d by \code{\link[=dbClearResult]{dbClearResult()}}.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbExecute")}
}
\section{Implementation notes}{

Subclasses should override this method only if they provide some sort of
performance optimization.
}

\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "cars", head(cars, 3))
dbReadTable(con, "cars")   # there are 3 rows
dbExecute(con,
  "INSERT INTO cars (speed, dist) VALUES (1, 1), (2, 2), (3, 3);")
dbReadTable(con, "cars")   # there are now 6 rows

dbDisconnect(con)
}
\seealso{
For queries: \code{\link[=dbSendQuery]{dbSendQuery()}} and \code{\link[=dbGetQuery]{dbGetQuery()}}.

Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsValid}},
  \code{\link{dbListFields}}, \code{\link{dbListObjects}},
  \code{\link{dbListResults}}, \code{\link{dbListTables}},
  \code{\link{dbReadTable}}, \code{\link{dbRemoveTable}},
  \code{\link{dbSendQuery}}, \code{\link{dbSendStatement}},
  \code{\link{dbWriteTable}}
}
\concept{DBIConnection generics}
