% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_model_diagnostics.R
\name{plot.model_diagnostics}
\alias{plot.model_diagnostics}
\title{Plot Dataset Level Model Diagnostics}
\usage{
\method{plot}{model_diagnostics}(x, ..., variable = "y_hat", yvariable = "residuals", smooth = TRUE)
}
\arguments{
\item{x}{a data.frame to be explained, preprocessed by the \code{\link{model_diagnostics}} function}

\item{...}{other object to be included to the plot}

\item{variable}{character - name of the variable on OX axis to be explained, by default \code{y_hat}}

\item{yvariable}{character - name of the variable on OY axis, by default \code{residuals}}

\item{smooth}{logical shall the smooth line be added}
}
\value{
an object of the class \code{model_diagnostics_explainer}.
}
\description{
Plot Dataset Level Model Diagnostics
}
\examples{
apartments_lm_model <- lm(m2.price ~ ., data = apartments)
explainer_lm <- explain(apartments_lm_model,
                         data = apartments,
                         y = apartments$m2.price)
diag_lm <- model_diagnostics(explainer_lm)
diag_lm
plot(diag_lm)
\donttest{
library("ranger")
apartments_ranger_model <- ranger(m2.price ~ ., data = apartments)
explainer_ranger <- explain(apartments_ranger_model,
                         data = apartments,
                         y = apartments$m2.price)
diag_ranger <- model_diagnostics(explainer_ranger)
diag_ranger
plot(diag_ranger)
plot(diag_ranger, diag_lm)
plot(diag_ranger, diag_lm, variable = "y")
plot(diag_ranger, diag_lm, variable = "construction.year")
plot(diag_ranger, variable = "y", yvariable = "y_hat")
}
}
