% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_single_variable.R
\name{plot.variable_response_explainer}
\alias{plot.variable_response_explainer}
\title{Plots Marginal Model Explanations (Single Variable Responses)}
\usage{
\method{plot}{variable_response_explainer}(x, ...)
}
\arguments{
\item{x}{a single variable exlainer produced with the 'single_variable' function}

\item{...}{other explainers that shall be plotted together}
}
\value{
a ggplot2 object
}
\description{
Function 'plot.variable_response_explainer' plots marginal responses for one or more explainers.
}
\examples{
library("breakDown")
logit <- function(x) exp(x)/(1+exp(x))

HR_glm_model <- glm(left~., data = breakDown::HR_data, family = "binomial")
explainer_glm <- explain(HR_glm_model, data = HR_data, trans = logit)
expl_glm <- variable_response(explainer_glm, "satisfaction_level", "pdp", trans=logit)
plot(expl_glm)

 \dontrun{
library("randomForest")
HR_rf_model <- randomForest(factor(left)~., data = breakDown::HR_data, ntree = 100)
explainer_rf  <- explain(HR_rf_model, data = HR_data,
                       predict_function = function(model, x)
                             predict(model, x, type = "prob")[,2])
expl_rf  <- variable_response(explainer_rf, variable = "satisfaction_level",
                       type = "pdp", which.class = 2, prob = TRUE)
plot(expl_rf)

plot(expl_rf, expl_glm)

# Example for factor variable (with factorMerger)
library("randomForest")
expl_rf  <- variable_response(explainer_rf, variable =  "sales", type = "factor")
plot(expl_rf)

expl_glm  <- variable_response(explainer_glm, variable =  "sales", type = "factor")
plot(expl_glm)

# both models
plot(expl_rf, expl_glm)
 }

}
